/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.util.UtilLhia;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.SectionDocumentDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.DocumentRepository;
import ec.tws2.back.lhia.marcimex.models.entity.SectionDocument;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DocumentRepositoryImpl
implements DocumentRepository {
    UtilLhia util = new UtilLhia();
    String fileName = "documents/document_address.txt";
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Autowired
    private SectionDocumentDAO sectionDocumentDAO;

    public void uploadDocument() {
    }

    public String getDocumentUpload() {
        String string;
        InputStream resource = new ClassPathResource(this.fileName).getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "Error al leer el archivo: " + e.getMessage();
            }
        }
        reader.close();
        return string;
    }

    public void generateEmbeddingsForDocuments() {
        Long generate = 0L;
        List listSection = this.sectionDocumentDAO.listDocumentNG(generate);
        for (SectionDocument section : listSection) {
            String prompt = section.getText();
            String response = this.generateEmbedding(this.util.quitarTildes(prompt).toUpperCase());
            section.setEmbedding(response);
            section.setGenerate(Long.valueOf(1L));
            this.sectionDocumentDAO.save((Object)section);
        }
    }

    public String generateEmbedding(String prompt) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("input", (Object)prompt);
        jsonObject.put("model", (Object)"text-embedding-3-large");
        jsonObject.put("dimensions", 3072);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity requestEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.exchange(this.url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        JSONObject responseJson = new JSONObject((String)responseEntity.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("data");
        String embedding = embeddingArray.join("embedding");
        return this.util.parseEmbedding(embedding);
    }
}

