/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.common.util.UtilLhia;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.RolDao;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ActivityRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.CampaignRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ConversationRepository;
import ec.tws2.back.lhia.marcimex.models.data.ConversationHistory;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import ec.tws2.back.lhia.marcimex.models.entity.Rol;
import ec.tws2.back.lhia.marcimex.models.request.StartConversationRequest;
import ec.tws2.back.lhia.marcimex.models.response.StartConversationResponse;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ConversationRepositoryImpl
implements ConversationRepository {
    private static final Logger log = LoggerFactory.getLogger(ConversationRepositoryImpl.class);
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private CampaignRepository campaignRepository;
    @Autowired
    private RolDao rolDAO;
    UtilLhia utilLhia = new UtilLhia();

    public ResponseEntity<ResponseResult<?>> getIdentificationLastConversationHistory(ConversationHistory conversationHistory) {
        try {
            PageRequest pageable = PageRequest.of((int)0, (int)1);
            Page resultHistoryConversation = this.conversacionDAO.findHistoryConversation(conversationHistory.getIdPlatform(), conversationHistory.getPlatform(), (Pageable)pageable);
            if (resultHistoryConversation.hasContent()) {
                Conversacion lastConversation = (Conversacion)resultHistoryConversation.getContent().get(0);
                List listActivity = this.activityRepository.listActivity(lastConversation.getId_conversacion());
                if (listActivity.isEmpty()) {
                    return TransactionCustom.ok((String)"OK", (Object)"");
                }
                String data = listActivity.stream().map(activity -> {
                    if ("BOT".equals(activity.getTexto_pregunta())) {
                        return activity.getTexto_respuesta();
                    }
                    return String.format("USER \ud83d\udc64\ud83d\udcac:\nMENSAJE:\nAsesor\nFECHA:%s", ConversationRepositoryImpl.convertDateFormat((String)activity.getFecha().toString()));
                }).collect(Collectors.joining());
                return TransactionCustom.ok((String)"OK", (Object)data);
            }
        }
        catch (Exception e) {
            log.info("Error al obtener historial de conversaci\u00f3n: {}", (Object)e.getMessage());
        }
        return TransactionCustom.ok((String)"OK", (Object)"");
    }

    public Map<String, Long> getUniqueUserCount(Date startDate, Date endDate) {
        Long uniqueUserCount = this.conversacionDAO.getUniqueUserCount(startDate, endDate);
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("userCount", uniqueUserCount);
        return result;
    }

    public static String convertDateFormat(String dateStr) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        LocalDateTime dateTime = LocalDateTime.parse(dateStr, inputFormatter);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        return dateTime.format(outputFormatter);
    }

    public ResponseEntity<?> startConversacion(StartConversationRequest request) {
        Optional existingConversation = this.conversacionDAO.findByIdentificador(request.getIdentification());
        Conversacion conversation = existingConversation.orElseGet(() -> {
            Conversacion newConversation = this.buildConversationFromRequest(request);
            return (Conversacion)this.conversacionDAO.save((Object)newConversation);
        });
        StartConversationResponse response = this.buildBaseResponse(conversation);
        if (existingConversation.isEmpty()) {
            this.campaignRepository.findMostRelevantByName(request.getMessageInitial()).ifPresent(tag -> {
                this.campaignRepository.registerConversationWithTag(tag.getId(), BigDecimal.valueOf(conversation.getId_conversacion()));
                response.setCanalCode(tag.getCanal().getCanalCode());
            });
        }
        return TransactionCustom.ok((Object)response);
    }

    private Conversacion buildConversationFromRequest(StartConversationRequest request) {
        Conversacion conversation = new Conversacion();
        conversation.setUsuario(request.getUser());
        conversation.setIdentificador(request.getIdentification());
        conversation.setNumero_celular(Optional.ofNullable(request.getPlatformId()).orElse("9999999999"));
        conversation.setCanal(request.getPlatform());
        String message = request.getMessageInitial() != null && !request.getMessageInitial().trim().isEmpty() ? request.getMessageInitial().trim() : null;
        conversation.setMessageInitial(message);
        conversation.setRoles((Rol)this.rolDAO.findByDescripcion(request.getRol()).orElseThrow(() -> new IllegalArgumentException("Role not found")));
        conversation.setFecha(this.utilLhia.fechaEcuador());
        return conversation;
    }

    private StartConversationResponse buildBaseResponse(Conversacion conversation) {
        StartConversationResponse response = new StartConversationResponse();
        response.setIdConversation(conversation.getId_conversacion());
        return response;
    }

    public Optional<Conversacion> findByIdentificador(String identificador) {
        return this.conversacionDAO.findByIdentificador(identificador);
    }

    @Transactional
    public int assignIteratingAgent(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        LocalDateTime now = LocalDateTime.now();
        List conversations = this.conversacionDAO.findAllById(ids);
        int updated = 0;
        for (Conversacion c : conversations) {
            if (Boolean.TRUE.equals(c.getAsignadoAgente())) continue;
            c.setAsignadoAgente(Boolean.valueOf(true));
            c.setFechaAsignacionAgente(now);
            ++updated;
        }
        this.conversacionDAO.saveAll((Iterable)conversations);
        return updated;
    }

    public Conversacion save(Conversacion conversacion) {
        return (Conversacion)this.conversacionDAO.save((Object)conversacion);
    }

    public Optional<Conversacion> getConversationByIdentificationLast(String idPlatform) {
        PageRequest pageable = PageRequest.of((int)0, (int)1);
        Page resultConversation = this.conversacionDAO.findLastByNumeroCelular(idPlatform, (Pageable)pageable);
        if (resultConversation.hasContent()) {
            return Optional.of((Conversacion)resultConversation.getContent().get(0));
        }
        return Optional.empty();
    }
}

