/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversationLastPurchaseViewDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ConversationLastPurchaseRepository;
import ec.tws2.back.lhia.marcimex.models.view.ConversationLastPurchaseView;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConversationLastPurchaseRepositoryImpl
implements ConversationLastPurchaseRepository {
    private static final Logger log = LoggerFactory.getLogger(ConversationLastPurchaseRepositoryImpl.class);
    private final ConversationLastPurchaseViewDAO conversationLastPurchaseViewDAO;

    public List<ConversationLastPurchaseView> findConversationLastPurchase(int intervalHours, int ventanaHoras) {
        Instant now = Instant.now();
        Instant endInstant = now.minus(intervalHours, ChronoUnit.HOURS);
        Instant startInstant = endInstant.minus(ventanaHoras, ChronoUnit.HOURS);
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime start = LocalDateTime.ofInstant(startInstant, zone);
        LocalDateTime end = LocalDateTime.ofInstant(endInstant, zone);
        log.info("Buscando registros antiguos (Antig\u00fcedad > {}h). Rango: {} hasta {}", new Object[]{intervalHours, start, end});
        return this.conversationLastPurchaseViewDAO.findByConversationDateRange(start, end);
    }

    public ConversationLastPurchaseRepositoryImpl(ConversationLastPurchaseViewDAO conversationLastPurchaseViewDAO) {
        this.conversationLastPurchaseViewDAO = conversationLastPurchaseViewDAO;
    }
}

