/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDetalleDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.PurchaseDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ClienteRepository;
import ec.tws2.back.lhia.marcimex.models.dto.ClienteListaDTO;
import ec.tws2.back.lhia.marcimex.models.dto.ClienteResumenDTO;
import ec.tws2.back.lhia.marcimex.models.dto.CompraResumenDTO;
import ec.tws2.back.lhia.marcimex.models.dto.ConsultaProductoDTO;
import ec.tws2.back.lhia.marcimex.models.dto.InteraccionDTO;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ClienteRepositoryImpl
implements ClienteRepository {
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private PurchaseDAO purchaseDAO;

    public Page<ClienteListaDTO> obtenerListadoClientes(Pageable pageable) {
        Page numerosUnicos = this.conversacionDAO.findDistinctNumeroCelular(pageable);
        List lista = numerosUnicos.getContent().stream().map(numero -> {
            Page ultimaConvPage = this.conversacionDAO.findLastByNumeroCelular(numero, (Pageable)PageRequest.of((int)0, (int)1));
            String nombre = "N/A";
            String canal = "N/A";
            String fecha = "N/A";
            if (!ultimaConvPage.isEmpty()) {
                Conversacion c = (Conversacion)ultimaConvPage.getContent().get(0);
                nombre = c.getUsuario();
                canal = c.getCanal();
                fecha = c.getFecha() != null ? c.getFecha().toString() : "N/A";
            }
            return new ClienteListaDTO(numero, nombre, canal, fecha);
        }).collect(Collectors.toList());
        return new PageImpl(lista, pageable, numerosUnicos.getTotalElements());
    }

    public ClienteResumenDTO obtenerDetalleCliente(String telefono) {
        List conversaciones = this.conversacionDAO.findAllByNumeroCelular(telefono);
        List convIds = conversaciones.stream().map(Conversacion::getId_conversacion).collect(Collectors.toList());
        List<Object> interacciones = new ArrayList();
        if (!convIds.isEmpty()) {
            interacciones = this.conversacionDetalleDAO.findAllByConversacionIds(convIds).stream().map(cd -> new InteraccionDTO(cd.getRol(), cd.getMensaje(), cd.getFecha())).collect(Collectors.toList());
        }
        List allPurchases = this.purchaseDAO.findByPlatformId(telefono);
        List actualPurchases = allPurchases.stream().filter(p -> p.getCompleted() != null && p.getCompleted() != false).collect(Collectors.toList());
        List consultations = allPurchases.stream().filter(p -> p.getCompleted() == null || p.getCompleted() == false).collect(Collectors.toList());
        List comprasDTO = actualPurchases.stream().map(p -> {
            List<Object> items = new ArrayList();
            if (p.getPurchaseDetails() != null) {
                items = p.getPurchaseDetails().stream().map(d -> d.getDescription() != null ? d.getDescription() : "Producto sin t\u00edtulo").collect(Collectors.toList());
            }
            return new CompraResumenDTO(p.getId(), p.getTotalAmount(), p.getPaymentMethod(), p.getCreatedAt(), p.getCompleted(), items);
        }).collect(Collectors.toList());
        List consultasDTO = consultations.stream().flatMap(p -> {
            if (p.getPurchaseDetails() == null) {
                return new ArrayList().stream();
            }
            return p.getPurchaseDetails().stream().map(d -> new ConsultaProductoDTO(d.getDescription() != null ? d.getDescription() : "Producto consultado", d.getProductId(), p.getCreatedAt()));
        }).collect(Collectors.toList());
        Double totalGastado = actualPurchases.stream().mapToDouble(p -> p.getTotalAmount() != null ? p.getTotalAmount() : 0.0).sum();
        Integer numCompras = actualPurchases.size();
        ClienteResumenDTO resumen = new ClienteResumenDTO();
        resumen.setNombre(!conversaciones.isEmpty() ? ((Conversacion)conversaciones.get(0)).getUsuario() : "Cliente Point");
        resumen.setTelefono(telefono);
        resumen.setTotalGastado(totalGastado);
        resumen.setNumeroCompras(numCompras);
        resumen.setCompras(comprasDTO);
        resumen.setInteracciones(interacciones);
        resumen.setConsultasProductos(consultasDTO);
        return resumen;
    }
}

