/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.CartDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ProductDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.CartRepository;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.entity.Cart;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import ec.tws2.back.lhia.marcimex.models.entity.ItemCart;
import ec.tws2.back.lhia.marcimex.models.entity.Product;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CartRepositoryImpl
implements CartRepository {
    private CartDAO cartDao;
    private ProductDAO productDAO;
    private ConversacionDAO conversacionDAO;

    public ResponseEntity<ResponseResult<?>> saveCart(Cart cart, String identifier) {
        try {
            List itemsNew = cart.getItems().stream().map(item -> {
                Product productOpt = this.productDAO.getProductByIdProduct(item.getProduct().getId());
                if (productOpt == null) {
                    throw new RuntimeException("Producto con ID " + item.getProduct().getId() + " no existe.");
                }
                ItemCart newItemCart = new ItemCart();
                newItemCart.setProduct(productOpt);
                newItemCart.setPrice(item.getPrice());
                newItemCart.setQuantity(item.getQuantity());
                newItemCart.setTitle(item.getTitle());
                return newItemCart;
            }).collect(Collectors.toList());
            if (itemsNew.isEmpty()) {
                return TransactionCustom.error((String)"Error al crear el carrito. No hay items v\u00e1lidos.");
            }
            Optional optionalConversation = this.conversacionDAO.findByIdentificador(identifier);
            if (!optionalConversation.isPresent()) {
                return TransactionCustom.error((String)"Conversaci\u00f3n no encontrada.");
            }
            Conversacion conversation = (Conversacion)optionalConversation.get();
            cart.setConversacion(conversation);
            cart.setItems(itemsNew);
            Cart savedCart = (Cart)this.cartDao.save((Object)cart);
            if (savedCart.getId() != null) {
                return TransactionCustom.ok();
            }
            return TransactionCustom.error((String)"Error al crear el carrito.");
        }
        catch (Exception e) {
            return TransactionCustom.error((String)("Error al crear producto: " + e.getMessage()));
        }
    }

    public CartRepositoryImpl(CartDAO cartDao, ProductDAO productDAO, ConversacionDAO conversacionDAO) {
        this.cartDao = cartDao;
        this.productDAO = productDAO;
        this.conversacionDAO = conversacionDAO;
    }
}

