/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.repositoriesImpl;

import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.CampaignTagDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.CanalDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.TagsCampaignViewDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.UserTagDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.CampaignRepository;
import ec.tws2.back.lhia.marcimex.models.entity.TCampaignTag;
import ec.tws2.back.lhia.marcimex.models.entity.TCanal;
import ec.tws2.back.lhia.marcimex.models.entity.TUserTag;
import ec.tws2.back.lhia.marcimex.models.request.CampaignTagRequest;
import ec.tws2.back.lhia.marcimex.models.view.TagsCampaignView;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CampaignRepositoryImpl
implements CampaignRepository {
    private final CanalDAO canalDAO;
    private final CampaignTagDAO tagDAO;
    private final UserTagDAO userTagDAO;
    private final TagsCampaignViewDAO campaignDAO;

    public TCanal createCanal(TCanal canal) {
        return (TCanal)this.canalDAO.save((Object)canal);
    }

    public TCampaignTag createTag(TCampaignTag tag, Integer canalId) {
        TCanal canal = (TCanal)this.canalDAO.findById((Object)canalId).orElseThrow();
        tag.setCanal(canal);
        return (TCampaignTag)this.tagDAO.save((Object)tag);
    }

    public TUserTag registerConversationWithTag(Integer tagId, BigDecimal idConversacion) {
        TCampaignTag tag = (TCampaignTag)this.tagDAO.findById((Object)tagId).orElseThrow();
        TUserTag userTag = new TUserTag();
        userTag.setTag(tag);
        userTag.setIdConversacion(idConversacion);
        return (TUserTag)this.userTagDAO.save((Object)userTag);
    }

    public Optional<TCampaignTag> findMostRelevantByName(String name) {
        return this.tagDAO.findMostRelevantByName(name);
    }

    public Optional<TCampaignTag> findByNameTag(String name) {
        return this.tagDAO.findByNameAndActiveTrue(name);
    }

    public ResponseEntity<?> findCanalsActive() {
        return TransactionCustom.ok((Object)this.canalDAO.findByActiveTrue());
    }

    public ResponseEntity<?> createCampaign(CampaignTagRequest request) {
        Optional optionalCanal = this.canalDAO.findById((Object)request.getIdCanal());
        if (optionalCanal.isEmpty()) {
            return TransactionCustom.error((String)"El canal no fue encontrado.");
        }
        Optional dataFind = this.tagDAO.findById((Object)(request.getId() != null ? request.getId() : 0));
        boolean isUpdating = dataFind.isPresent();
        if (!(isUpdating && ((TCampaignTag)dataFind.get()).getName().equals(request.getName()) || !this.tagDAO.existsByName(request.getName()))) {
            return TransactionCustom.error((String)"Este tag ya ha sido creado previamente.");
        }
        TCampaignTag campaignTag = isUpdating ? (TCampaignTag)dataFind.get() : new TCampaignTag();
        campaignTag.setName(request.getName());
        campaignTag.setDescription(request.getDescription());
        campaignTag.setCanal((TCanal)optionalCanal.get());
        campaignTag.setActive(Boolean.valueOf(isUpdating ? ((TCampaignTag)dataFind.get()).getActive() : true));
        campaignTag.setCreatedAt(LocalDateTime.now());
        TCampaignTag data = (TCampaignTag)this.tagDAO.save((Object)campaignTag);
        return TransactionCustom.ok((Object)data);
    }

    public ResponseEntity<?> findCampaignsWithCanal() {
        List dataList = this.tagDAO.findCampaignsWithCanal();
        return TransactionCustom.ok((Object)dataList);
    }

    public ResponseEntity<?> findTagsCampaign(Pageable pageable, LocalDate startDate, LocalDate endDate) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.MAX;
        Page data = this.campaignDAO.findByCreatedAtBetweenOrderByCreatedAtDesc(start, end, pageable);
        return TransactionCustom.ok((Object)data);
    }

    public List<TagsCampaignView> findTagsCampaignCSV(LocalDate startDate, LocalDate endDate) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDateTime.MIN;
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.MAX;
        return this.campaignDAO.findAllByCreatedAtBetweenOrderByCreatedAtDesc(start, end);
    }

    public ResponseEntity<?> changeStatusCampaign(Integer id, Boolean active) {
        Optional tagFind = this.tagDAO.findById((Object)id);
        if (!tagFind.isPresent()) {
            return TransactionCustom.error((String)"El tag no fue encontrado.");
        }
        ((TCampaignTag)tagFind.get()).setActive(active);
        this.tagDAO.save((Object)((TCampaignTag)tagFind.get()));
        return TransactionCustom.ok();
    }

    public ResponseEntity<?> getTagReport(LocalDate startDate, LocalDate endDate) {
        List listTagReportProjection = this.tagDAO.getTagReport(startDate, endDate);
        return TransactionCustom.ok((Object)listTagReportProjection);
    }

    public CampaignRepositoryImpl(CanalDAO canalDAO, CampaignTagDAO tagDAO, UserTagDAO userTagDAO, TagsCampaignViewDAO campaignDAO) {
        this.canalDAO = canalDAO;
        this.tagDAO = tagDAO;
        this.userTagDAO = userTagDAO;
        this.campaignDAO = campaignDAO;
    }
}

