/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.service.export;

import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import ec.tws2.back.lhia.marcimex.models.dto.TagsCampaignCsv;
import ec.tws2.back.lhia.marcimex.models.dto.UserPurchaseDetailCsv;
import ec.tws2.back.lhia.marcimex.models.view.TagsCampaignView;
import ec.tws2.back.lhia.marcimex.models.view.UserPurchaseDetailView;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CsvExportService {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void exportTagsCampaignCsv(List<TagsCampaignView> reports, OutputStream outputStream) throws IOException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        byte[] bom = new byte[]{-17, -69, -65};
        outputStream.write(bom);
        List<TagsCampaignCsv> csvList = reports.stream().map(view -> {
            TagsCampaignCsv csv = new TagsCampaignCsv();
            csv.setId(view.getId());
            csv.setUser(view.getUser());
            csv.setPlatformId(view.getPlatformId());
            csv.setPlatform(view.getPlatform());
            csv.setCampaignName(view.getCampaignName());
            csv.setCampaignDescription(view.getCampaignDescription());
            csv.setCanalName(view.getCanalName());
            csv.setCreatedAt(view.getCreatedAt() != null ? view.getCreatedAt().format(FORMATTER) : "");
            return csv;
        }).toList();
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).withQuotechar('\u0000').build();
        beanToCsv.write(csvList);
        ((Writer)writer).flush();
    }

    public void exportUserConversationCartItemCsv(List<UserPurchaseDetailView> views, OutputStream outputStream) throws IOException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        byte[] bom = new byte[]{-17, -69, -65};
        outputStream.write(bom);
        List<UserPurchaseDetailCsv> csvList = views.stream().map(view -> {
            String urlPurchase = view.getUrlPurchase();
            UserPurchaseDetailCsv csv = new UserPurchaseDetailCsv();
            csv.setDetailId(view.getDetailId());
            csv.setUsername(view.getUsername());
            csv.setPhoneNumber(view.getPhoneNumber());
            csv.setTimeSlot(CsvExportService.translateTimeZone((String)view.getTimeSlot()));
            csv.setTimeRange(view.getTimeRange());
            csv.setLastInteractionDate(view.getLastInteractionDate() != null ? view.getLastInteractionDate().toLocalDateTime().format(FORMATTER) : "_");
            csv.setProductId(view.getProductId());
            csv.setProductDescription(CsvExportService.sanitizeForCsv((String)view.getProductDescription()));
            csv.setProductImage(view.getProductImage());
            csv.setUrlPurchase(urlPurchase == null || urlPurchase.trim().isEmpty() ? "-" : urlPurchase);
            csv.setInvoiced(view.getInvoiced() != false ? "FACTURADO" : "_");
            return csv;
        }).toList();
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).withQuotechar('\u0000').build();
        beanToCsv.write(csvList);
        ((Writer)writer).flush();
    }

    public static String translateTimeZone(String timeSlot) {
        if (timeSlot == null) {
            return "";
        }
        return switch (timeSlot.toUpperCase()) {
            case "MORNING" -> "Ma\u00f1ana";
            case "AFTERNOON" -> "Tarde";
            case "NIGHT" -> "Noche";
            case "DAWN" -> "Madrugada";
            default -> timeSlot;
        };
    }

    public static String sanitizeForCsv(String input) {
        if (input == null) {
            return "product";
        }
        return input.replaceAll("[\\n\\r]", " ").replaceAll(",", " ").replaceAll("\"", "").replaceAll("'", "").replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "").trim();
    }
}

