/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.facade;

import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.infrastructure.client.MetaMarciApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.mapper.ScheduleAssignmentMapper;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ConversationLastPurchaseRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ConversationRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.TScheduleAssignmentRepository;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.dto.ScheduleAssignmentDto;
import ec.tws2.back.lhia.marcimex.models.entity.TScheduleAssignment;
import ec.tws2.back.lhia.marcimex.models.request.MetaMarciRequest;
import ec.tws2.back.lhia.marcimex.models.request.UpdateScheduleAssignmentRequest;
import ec.tws2.back.lhia.marcimex.models.view.ConversationLastPurchaseView;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleAssignmentFacade {
    private static final Logger log = LoggerFactory.getLogger(ScheduleAssignmentFacade.class);
    private final int TOLERENCIA_MINUTOS = 5;
    private final int VENTANA_HORAS = 16;
    private final TScheduleAssignmentRepository scheduleRepository;
    private final ConversationLastPurchaseRepository conversationLastPurchaseRepository;
    private final ConversationRepository conversationRepository;
    private final MetaMarciApiClient metaMarciApiClient;

    public ScheduleAssignmentFacade(TScheduleAssignmentRepository scheduleRepository, ConversationLastPurchaseRepository conversationLastPurchaseRepository, ConversationRepository conversationRepository, MetaMarciApiClient metaMarciApiClient) {
        this.scheduleRepository = scheduleRepository;
        this.conversationLastPurchaseRepository = conversationLastPurchaseRepository;
        this.conversationRepository = conversationRepository;
        this.metaMarciApiClient = metaMarciApiClient;
    }

    public List<ScheduleAssignmentDto> getScheduleAssignmentList() {
        return this.scheduleRepository.listScheduleAssignment().stream().sorted(Comparator.comparing(TScheduleAssignment::getId)).map(ScheduleAssignmentMapper::toDto).toList();
    }

    public ResponseEntity<ResponseResult<?>> updateScheduleAssignment(Long id, UpdateScheduleAssignmentRequest dto) {
        if (!dto.getStartTime().isBefore(dto.getEndTime())) {
            return TransactionCustom.error((String)"La hora de inicio debe ser menor que la hora de fin.");
        }
        long windowMinutes = Duration.between(dto.getStartTime(), dto.getEndTime()).toMinutes();
        long freqMinutes = (long)dto.getFrequencyHours().intValue() * 60L;
        if (freqMinutes > windowMinutes) {
            return TransactionCustom.error((String)"La frecuencia no puede ser mayor que el tiempo entre la hora de inicio y la hora de fin.");
        }
        Optional dataFind = this.scheduleRepository.findById(id);
        if (!dataFind.isPresent()) {
            return TransactionCustom.error((String)"No recibimos la informaci\u00f3n del horario. Por favor, intenta nuevamente.");
        }
        TScheduleAssignment scheduleAss = (TScheduleAssignment)dataFind.get();
        scheduleAss.setStartTime(dto.getStartTime());
        scheduleAss.setEndTime(dto.getEndTime());
        scheduleAss.setFrequencyHours(dto.getFrequencyHours());
        scheduleAss.setActive(dto.getActive());
        this.scheduleRepository.save(scheduleAss);
        return TransactionCustom.ok((String)"OK", (Object)ScheduleAssignmentMapper.toDto((TScheduleAssignment)scheduleAss));
    }

    public void executerAssignation() {
        LocalDateTime now = LocalDateTime.now();
        int dia = now.getDayOfWeek().getValue();
        LocalTime horaActual = now.toLocalTime();
        log.info("Dia : {} hora : {}", (Object)dia, (Object)horaActual);
        Optional scheduleAssignment = this.scheduleRepository.findScheduleAssignmentForDay(Short.valueOf((short)dia));
        if (scheduleAssignment.isPresent()) {
            log.info("Horario Asignacion Encontrado {}", scheduleAssignment.get());
            TScheduleAssignment hour = (TScheduleAssignment)scheduleAssignment.get();
            boolean shouldRun = this.buildExecutionTimes(now, hour.getStartTime(), hour.getEndTime(), hour.getFrequencyHours().intValue(), 5);
            if (shouldRun) {
                log.info("Debe ejecutarse el proceso de asignaci\u00f3n ahora.");
                this.startAssignation(hour.getFrequencyHours().intValue());
            } else {
                log.info("No corresponde ejecutar ahora.");
            }
        } else {
            log.info("Horario Asignacion NO Encontrado");
        }
    }

    public void startAssignation(int intervalHours) {
        log.info("startAssignation | Inicio");
        List dataListConversation = this.conversationLastPurchaseRepository.findConversationLastPurchase(intervalHours, 16);
        if (dataListConversation == null || dataListConversation.isEmpty()) {
            log.info("startAssignation | No hay conversaciones para procesar");
            return;
        }
        List<Long> idsToUpdate = dataListConversation.stream().filter(item -> {
            try {
                boolean sent = this.sendMessageAsesor(item.getPlatformId(), item.getNick(), item.getProductLast());
                if (sent) {
                    log.debug("Mensaje enviado con \u00e9xito a: {}", (Object)item.getNick());
                    return true;
                }
            }
            catch (Exception e) {
                log.error("Error enviando mensaje a nick: {} | Error: {}", (Object)item.getNick(), (Object)e.getMessage());
            }
            return false;
        }).map(ConversationLastPurchaseView::getConversationId).toList();
        if (idsToUpdate.isEmpty()) {
            log.warn("startAssignation | No se enviaron mensajes correctamente | totalIntentos={}", (Object)dataListConversation.size());
            return;
        }
        log.info("startAssignation | Actualizando base de datos | count={}", (Object)idsToUpdate.size());
        int updated = this.conversationRepository.assignIteratingAgent(idsToUpdate);
        log.info("startAssignation | Fin | registrosActualizados={}", (Object)updated);
    }

    public boolean buildExecutionTimes(LocalDateTime now, LocalTime horaInicio, LocalTime horaFin, int frecuenciaHoras, int toleranciaMinutos) {
        if (frecuenciaHoras <= 0) {
            log.info("Frecuencia inv\u00e1lida: {} (debe ser > 0). No se ejecuta.", (Object)frecuenciaHoras);
            return false;
        }
        if (toleranciaMinutos < 0) {
            log.info("Tolerancia inv\u00e1lida: {} (debe ser >= 0). No se ejecuta.", (Object)toleranciaMinutos);
            return false;
        }
        if (!horaInicio.isBefore(horaFin)) {
            log.info("Ventana inv\u00e1lida: inicio={} fin={}. No se ejecuta.", (Object)horaInicio, (Object)horaFin);
            return false;
        }
        LocalTime ahora = now.toLocalTime();
        if (ahora.isBefore(horaInicio) || !ahora.isBefore(horaFin)) {
            log.info("Fuera de ventana. ahora={}, ventana=[{}, {}). No se ejecuta.", new Object[]{ahora, horaInicio, horaFin});
            return false;
        }
        long totalMinDesdeInicio = Duration.between(horaInicio, ahora).toMinutes();
        long freqMin = (long)frecuenciaHoras * 60L;
        long k = Math.floorDiv(totalMinDesdeInicio, freqMin);
        LocalTime tickPrev = horaInicio.plusMinutes(k * freqMin);
        LocalTime tickNext = tickPrev.plusMinutes(freqMin);
        long diffPrev = Math.abs(Duration.between(tickPrev, ahora).toMinutes());
        long diffNext = Long.MAX_VALUE;
        if (tickNext.isBefore(horaFin)) {
            diffNext = Math.abs(Duration.between(tickNext, ahora).toMinutes());
        }
        LocalTime tickCercano = diffPrev <= diffNext ? tickPrev : tickNext;
        long diffMin = Math.min(diffPrev, diffNext);
        boolean shouldRun = diffMin <= (long)toleranciaMinutos;
        log.info("Evaluaci\u00f3n ejecuci\u00f3n: ahora={}, ventana=[{}, {}), frecuencia={}h, tolerancia={}min,tickPrev={}, diffPrev={}min, tickNext={}, diffNext={}min, tickCercano={}, diffMin={}min, shouldRun={}", new Object[]{ahora, horaInicio, horaFin, frecuenciaHoras, toleranciaMinutos, tickPrev, diffPrev, tickNext.isBefore(horaFin) ? tickNext : null, diffNext == Long.MAX_VALUE ? null : Long.valueOf(diffNext), tickCercano, diffMin, shouldRun});
        return shouldRun;
    }

    public boolean sendMessageAsesor(String platformId, String nick, String product) {
        MetaMarciRequest apiRequest = MetaMarciRequest.builder().conversationId(platformId).callbackId("TWS-ef54d7e6-7de6-4bb1-8c44-2cfc9c66acba").nick(nick).initialMessage(ScheduleAssignmentFacade.generateMessageCartForget((String)product)).event("THINKAGENT").tipo("default").build();
        return this.metaMarciApiClient.updateStateConversation(apiRequest);
    }

    public static String generateMessageCartForget(String producto) {
        return "\ud83d\udd04 Redirecci\u00f3n Marci | \ud83d\uded2 Carrito abandonado\n\n\ud83d\udc64 El usuario mostr\u00f3 inter\u00e9s en:\n " + producto + "\n\n\u27a1\ufe0f Redirecci\u00f3n para seguimiento \ud83e\udd1d\u2728";
    }
}

