/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.facade;

import com.nimbusds.jose.shaded.gson.Gson;
import ec.tws2.back.lhia.marcimex.common.transactions.TransactionCustom;
import ec.tws2.back.lhia.marcimex.common.util.PurchaseUtils;
import ec.tws2.back.lhia.marcimex.common.util.TemplateUtil;
import ec.tws2.back.lhia.marcimex.infrastructure.client.LhiaV3Client;
import ec.tws2.back.lhia.marcimex.infrastructure.client.MarcimexApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.client.OpenAiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.client.VtexApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ProductSuggestDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.PurchaseDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MarcimexRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MxVtexRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ProductMongoRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ProductSuggestRepository;
import ec.tws2.back.lhia.marcimex.models.data.OrderForm;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.dto.ActivityResponseDTO;
import ec.tws2.back.lhia.marcimex.models.dto.ActivitySaveDTO;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import ec.tws2.back.lhia.marcimex.models.entity.ProductMongo;
import ec.tws2.back.lhia.marcimex.models.entity.ProductSuggest;
import ec.tws2.back.lhia.marcimex.models.entity.Purchase;
import ec.tws2.back.lhia.marcimex.models.entity.PurchaseDetail;
import ec.tws2.back.lhia.marcimex.models.enums.PurchaseType;
import ec.tws2.back.lhia.marcimex.models.enums.StatusTransactions;
import ec.tws2.back.lhia.marcimex.models.response.LhiaV3ApiResponse;
import ec.tws2.back.lhia.marcimex.models.response.OpenAiResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class PurchaseFacade {
    private static final Logger log = LoggerFactory.getLogger(PurchaseFacade.class);
    @Autowired
    private PurchaseDAO purchaseDAO;
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ProductSuggestDAO productSuggestDAO;
    @Autowired
    private ProductSuggestRepository productSuggestRepository;
    @Autowired
    private VtexApiClient vtexApiClient;
    @Autowired
    private LhiaV3Client lhiaV3Client;
    @Autowired
    private MarcimexApiClient marcimexApiClient;
    @Autowired
    private OpenAiClient openAiClient;
    @Autowired
    private ProductMongoRepository productMongoRepository;
    @Autowired
    private MarcimexRepository marcimexRepository;
    @Autowired
    private MxVtexRepository mxVtexRepository;
    @Value(value="${vtex.url.purchase}")
    private String vtexPurchaseUrl;

    public ResponseEntity<ResponseResult<?>> checkActivity(ActivitySaveDTO dto, String token) {
        ResponseEntity validationResponse = this.validateActivity(dto);
        if (validationResponse != null) {
            return validationResponse;
        }
        String activity = dto.getActivity().trim().toUpperCase();
        String event = PurchaseUtils.getEventName((String)activity);
        String productId = PurchaseUtils.getProductIdFromEvent((String)activity, (String)event);
        log.info("IdProduct : {}", (Object)productId);
        log.info("EventDetail : {}", (Object)"DETAIL");
        log.info("ActivityEvent : {}", (Object)event);
        this.logActivity(dto.getIdPlatform(), event, productId);
        return this.handleEvent(dto, event, productId, token);
    }

    private ResponseEntity<ResponseResult<?>> handleEvent(ActivitySaveDTO dto, String event, String productId, String token) {
        switch (event) {
            case "ADD_PRODUCT": {
                return this.addProduct(dto);
            }
            case "ADD_CART": {
                return this.addProductInCart(dto, productId, token);
            }
            case "VER_CARRITO": {
                return this.viewDetailPurchase(dto);
            }
            case "COMPRAR": {
                return this.setUpPurchaseV2(dto);
            }
            case "COMPRAR_CREDIT": {
                return this.addProductSetUpPurchase(dto, PurchaseType.CREDIT);
            }
            case "COMPRAR_CASH": {
                return this.addProductSetUpPurchase(dto, PurchaseType.CASH);
            }
            case "DETAIL": {
                return this.detailPurchase(productId);
            }
            case "FINALIZAR": {
                return this.finishPurchase(dto);
            }
        }
        return this.createResponse("NOT FOUND INSTRUCTION", false, "", Collections.emptyList());
    }

    public ResponseEntity<ResponseResult<?>> detailPurchase(String idProduct) {
        try {
            String rawJson = this.marcimexApiClient.getProductInfo(idProduct);
            if (rawJson == null || rawJson.isEmpty()) {
                return this.createResponse("No se pudo obtener informaci\u00f3n del producto.", false, "", Collections.emptyList());
            }
            JSONArray productArray = new JSONArray(rawJson);
            if (productArray.isEmpty()) {
                return this.createResponse("Producto no encontrado.", false, "", Collections.emptyList());
            }
            JSONObject product = productArray.getJSONObject(0);
            product.remove("productClusters");
            product.remove("items");
            String prompt = "Eres un asistente de ventas de Marcimex. Bas\u00e1ndote en el siguiente JSON de un producto, genera una ficha t\u00e9cnica clara y \u00fatil para el cliente.\n\nREGLAS ESTRICTAS:\n- Usa formato compatible con WhatsApp: un solo asterisco por lado *titulo* para negrita (NUNCA dobles asteriscos **), texto plano para el resto.\n- Usa emojis relacionados al tipo de producto (electrodom\u00e9stico, tecnolog\u00eda, hogar, etc.) en cada secci\u00f3n.\n- Incluye \u00daNICAMENTE: nombre del producto, marca, categor\u00eda, descripci\u00f3n y especificaciones t\u00e9cnicas relevantes.\n- NO incluyas precios, cuotas, descuentos ni ninguna informaci\u00f3n de pago o costo.\n- NO incluyas URLs, links ni referencias a p\u00e1ginas web.\n- NO incluyas IDs, c\u00f3digos internos ni campos t\u00e9cnicos irrelevantes para el cliente.\n- Responde SOLO en espa\u00f1ol.\n\nJSON del producto:\n" + String.valueOf(product);
            OpenAiResponse aiResponse = this.openAiClient.getChatResponse(prompt, 800);
            if (aiResponse == null || aiResponse.getChoices().isEmpty()) {
                return this.createResponse("No se pudo generar la ficha t\u00e9cnica del producto.", false, "", Collections.emptyList());
            }
            String techSheet = ((OpenAiResponse.Choice)aiResponse.getChoices().get(0)).getMessage().getContent().replace("**", "*");
            return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message(techSheet).hasEvent(Boolean.valueOf(true)).titleEvent("ADD").events(Arrays.asList("ADD_CART")).build());
        }
        catch (Exception e) {
            log.error("Error in detailPurchase for productId={}: {}", (Object)idProduct, (Object)e.getMessage());
            return this.createResponse("Error al obtener el detalle del producto.", false, "", Collections.emptyList());
        }
    }

    public ResponseEntity<ResponseResult<?>> setUpPurchase(ActivitySaveDTO activitySaveDTO) {
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message("\u00bfCu\u00e1l es tu preferencia de pago?").hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("COMPRAR_CASH", "COMPRAR_CREDIT")).build());
    }

    public ResponseEntity<ResponseResult<?>> setUpPurchaseV2(ActivitySaveDTO activitySaveDTO) {
        Gson gson = new Gson();
        String orderFormId = "";
        Object urlPurchase = "";
        ArrayList<JSONObject> orderItemsSave = new ArrayList<JSONObject>();
        Optional purchaseFind = this.purchaseDAO.findTopByPlatformIdAndCompletedAndStatusOrderByIdDesc(activitySaveDTO.getIdPlatform(), false, true);
        if (!purchaseFind.isPresent()) {
            return TransactionCustom.error((String)"PURCHASE NOT FOUND");
        }
        List listPurchaseDetail = ((Purchase)purchaseFind.get()).getPurchaseDetails();
        if (listPurchaseDetail == null || listPurchaseDetail.isEmpty()) {
            return TransactionCustom.error((String)"PURCHASE NOT FOUND");
        }
        try {
            for (int index = 0; index < listPurchaseDetail.size(); ++index) {
                PurchaseDetail item = (PurchaseDetail)listPurchaseDetail.get(index);
                JSONObject itemSave = new JSONObject();
                itemSave.put("quantity", (Object)item.getQuantity());
                itemSave.put("seller", (Object)"1");
                itemSave.put("id", (Object)item.getSkuId());
                itemSave.put("index", index);
                orderItemsSave.add(itemSave);
            }
            int typePurchase = "Cr\u00e9dito directo".equals(((Purchase)purchaseFind.get()).getPaymentMethod()) ? 1 : 2;
            JSONObject dataInitForm = this.vtexApiClient.initOrderForm(typePurchase);
            OrderForm orderForm = (OrderForm)gson.fromJson(dataInitForm.toString(), OrderForm.class);
            orderFormId = orderForm.getOrderFormId();
            this.vtexApiClient.addUTMOrderForm(orderFormId);
            this.vtexApiClient.addItemCart(orderFormId, orderItemsSave, typePurchase);
            urlPurchase = this.vtexPurchaseUrl + "?orderFormId=" + orderFormId + "#/cart";
            ((Purchase)purchaseFind.get()).setCompleted(Boolean.valueOf(true));
            ((Purchase)purchaseFind.get()).setUrlPurchase((String)urlPurchase);
            ((Purchase)purchaseFind.get()).setOrderFormId(orderFormId);
            this.purchaseDAO.save((Object)((Purchase)purchaseFind.get()));
            String messageFinally = "";
            messageFinally = typePurchase == 1 ? TemplateUtil.purchaseCredit() : TemplateUtil.purchaseCash();
            return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message(messageFinally).ctaUrl(new ActivityResponseDTO.CtaUrl("Ir al Link", (String)urlPurchase)).hasEvent(Boolean.valueOf(true)).titleEvent("\u2b07\ufe0f *Toque aqu\u00ed para finalizar el chat*").events(Arrays.asList("FINALIZAR")).build());
        }
        catch (Exception e) {
            log.info("Error generating Shopping Cart Link: " + e.getMessage());
            return TransactionCustom.error((String)"ERROR WHEN GENERATING CART");
        }
    }

    public ResponseEntity<ResponseResult<?>> viewDetailPurchase(ActivitySaveDTO activitySaveDTO) {
        Optional purchaseFind = this.purchaseDAO.findTopByPlatformIdAndCompletedAndStatusOrderByIdDesc(activitySaveDTO.getIdPlatform(), false, true);
        if (!purchaseFind.isPresent()) {
            return TransactionCustom.error((String)"PURCHASE NOT FOUND");
        }
        String dataView = PurchaseUtils.getDetailCart((Optional)purchaseFind);
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message(dataView).hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("COMPRAR")).build());
    }

    public ResponseEntity<ResponseResult<?>> addProductInCart(ActivitySaveDTO activitySaveDTO, String idProduct, String token) {
        if (idProduct == null || idProduct.trim().isEmpty()) {
            return this.createResponse("PRODUCT ID NOT VALID", false, "", Collections.emptyList());
        }
        Optional findConversation = this.marcimexRepository.getConversationByIdentificationLast(activitySaveDTO.getIdPlatform());
        if (!findConversation.isPresent()) {
            return this.createResponse("CONVERSATION ID NOT FOUND", false, "", Collections.emptyList());
        }
        LhiaV3ApiResponse.Product lhiaProduct = this.lhiaV3Client.getProductById(idProduct, token);
        if (lhiaProduct == null) {
            return this.createResponse("No disponemos de ese producto por el momento, pero puedes consultar sobre otro que te interese.", false, "", Collections.emptyList());
        }
        ProductMongo findProduct = ProductMongo.builder().productId(lhiaProduct.getProductId()).skuId(lhiaProduct.getSkuId()).title(lhiaProduct.getName()).productPriceWithTax(lhiaProduct.getPrice()).imageLink(lhiaProduct.getImage()).link(lhiaProduct.getLink()).brand(lhiaProduct.getBrand()).category(lhiaProduct.getCategory()).productDescription(lhiaProduct.getDescription()).inStock(String.valueOf(lhiaProduct.isInStock())).build();
        this.productSuggestRepository.saveProductMongo(activitySaveDTO.getIdPlatform(), activitySaveDTO.getPlatform(), ((Conversacion)findConversation.get()).getIdentificador(), findProduct);
        log.info("Conversation Find {}", (Object)findProduct);
        return this.addProductInCartCheck(ActivitySaveDTO.builder().platform(activitySaveDTO.getPlatform()).idPlatform(activitySaveDTO.getIdPlatform()).activity("ADD_PRODUCT").build());
    }

    public ResponseEntity<ResponseResult<?>> addProductInCartCheck(ActivitySaveDTO activitySaveDTO) {
        ProductSuggest productSuggestTemp = (ProductSuggest)this.productSuggestDAO.findById((Object)activitySaveDTO.getIdPlatform()).orElseThrow(() -> new RuntimeException("PRODUCT NOT FOUND"));
        Purchase purchaseFind = this.purchaseDAO.findTopByConversationIdAndPlatformIdAndCompletedAndStatusOrderByIdDesc(productSuggestTemp.getIdConversation(), productSuggestTemp.getIdPlatform(), false, true).orElseGet(() -> {
            Purchase newPurchase = new Purchase();
            newPurchase.setPaymentMethod("Solo consultaba");
            newPurchase.setTotalAmount(Double.valueOf(0.0));
            newPurchase.setPlatformId(productSuggestTemp.getIdPlatform());
            newPurchase.setPlatform(productSuggestTemp.getPlatform());
            newPurchase.setConversationId(productSuggestTemp.getIdConversation());
            newPurchase.setUrlPurchase("");
            newPurchase.setPurchaseDetails(new ArrayList());
            return (Purchase)this.purchaseDAO.save((Object)newPurchase);
        });
        if ("Solo consultaba".equals(purchaseFind.getPaymentMethod())) {
            return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message("Como deseas Pagar:").hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("COMPRAR_CASH", "COMPRAR_CREDIT")).build());
        }
        return this.addProduct(ActivitySaveDTO.builder().platform(activitySaveDTO.getPlatform()).idPlatform(activitySaveDTO.getIdPlatform()).activity("ADD_PRODUCT").build());
    }

    public ResponseEntity<ResponseResult<?>> addProductInCartProd(ActivitySaveDTO activitySaveDTO, String idProduct, String token) {
        if (idProduct == null || idProduct.trim().isEmpty()) {
            return this.createResponse("PRODUCT ID NOT VALID", false, "", Collections.emptyList());
        }
        Optional findConversation = this.marcimexRepository.getConversationByIdentificationLast(activitySaveDTO.getIdPlatform());
        if (!findConversation.isPresent()) {
            return this.createResponse("CONVERSATION ID NOT FOUND", false, "", Collections.emptyList());
        }
        LhiaV3ApiResponse.Product lhiaProductProd = this.lhiaV3Client.getProductById(idProduct, token);
        if (lhiaProductProd == null) {
            return this.createResponse("No disponemos de ese producto por el momento, pero puedes consultar sobre otro que te interese.", false, "", Collections.emptyList());
        }
        ProductMongo findProduct = ProductMongo.builder().productId(lhiaProductProd.getProductId()).skuId(lhiaProductProd.getSkuId()).title(lhiaProductProd.getName()).productPriceWithTax(lhiaProductProd.getPrice()).imageLink(lhiaProductProd.getImage()).link(lhiaProductProd.getLink()).brand(lhiaProductProd.getBrand()).category(lhiaProductProd.getCategory()).productDescription(lhiaProductProd.getDescription()).inStock(String.valueOf(lhiaProductProd.isInStock())).build();
        this.productSuggestRepository.saveProductMongo(activitySaveDTO.getIdPlatform(), activitySaveDTO.getPlatform(), ((Conversacion)findConversation.get()).getIdentificador(), findProduct);
        return this.addProduct(ActivitySaveDTO.builder().platform(activitySaveDTO.getPlatform()).idPlatform(activitySaveDTO.getIdPlatform()).activity("ADD_PRODUCT").build());
    }

    public ResponseEntity<ResponseResult<?>> addProductSetUpPurchase(ActivitySaveDTO activitySaveDTO, PurchaseType paymentMethod) {
        ProductSuggest productSuggestTemp = (ProductSuggest)this.productSuggestDAO.findById((Object)activitySaveDTO.getIdPlatform()).orElseThrow(() -> new RuntimeException("PRODUCT NOT FOUND"));
        Purchase purchaseFind = this.purchaseDAO.findTopByConversationIdAndPlatformIdAndCompletedAndStatusOrderByIdDesc(productSuggestTemp.getIdConversation(), productSuggestTemp.getIdPlatform(), false, true).orElseGet(() -> {
            Purchase newPurchase = new Purchase();
            newPurchase.setPaymentMethod(PurchaseType.CREDIT == paymentMethod ? "Cr\u00e9dito directo" : "Pagar efectivo \u00f3 tarjeta");
            newPurchase.setTotalAmount(Double.valueOf(0.0));
            newPurchase.setPlatformId(productSuggestTemp.getIdPlatform());
            newPurchase.setPlatform(productSuggestTemp.getPlatform());
            newPurchase.setConversationId(productSuggestTemp.getIdConversation());
            newPurchase.setUrlPurchase("");
            newPurchase.setPurchaseDetails(new ArrayList());
            return (Purchase)this.purchaseDAO.save((Object)newPurchase);
        });
        if (PurchaseType.CREDIT == paymentMethod) {
            purchaseFind.setPaymentMethod("Cr\u00e9dito directo");
        } else {
            purchaseFind.setPaymentMethod("Pagar efectivo \u00f3 tarjeta");
        }
        purchaseFind.getPurchaseDetails().stream().filter(detail -> productSuggestTemp.getProductId().equals(detail.getProductId())).findFirst().map(detail -> {
            detail.setQuantity(Integer.valueOf(detail.getQuantity() + 1));
            detail.setSubtotal(Double.valueOf((double)detail.getQuantity().intValue() * detail.getUnitPrice()));
            return detail;
        }).orElseGet(() -> {
            Double priceProduct = 0.0;
            if (PurchaseType.CREDIT == paymentMethod) {
                Long skuId = productSuggestTemp.getSkuId();
                priceProduct = this.mxVtexRepository.getPriceProductValue(skuId.intValue());
            } else {
                priceProduct = productSuggestTemp.getUnitPrice();
            }
            PurchaseDetail newDetail = new PurchaseDetail();
            newDetail.setProductId(productSuggestTemp.getProductId());
            newDetail.setSkuId(productSuggestTemp.getSkuId());
            newDetail.setQuantity(Integer.valueOf(1));
            newDetail.setUnitPrice(priceProduct);
            newDetail.setSubtotal(priceProduct);
            newDetail.setDescription(productSuggestTemp.getDescription());
            newDetail.setUrlImage(productSuggestTemp.getUrlImage());
            newDetail.setPurchase(purchaseFind);
            purchaseFind.getPurchaseDetails().add(newDetail);
            return newDetail;
        });
        double totalAmount = purchaseFind.getPurchaseDetails().stream().mapToDouble(PurchaseDetail::getSubtotal).sum();
        purchaseFind.setTotalAmount(Double.valueOf(totalAmount));
        this.purchaseDAO.save((Object)purchaseFind);
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message("\u2705 \u00a1Producto agregado a tu carrito!").hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("VER_CARRITO", "COMPRAR")).build());
    }

    public ResponseEntity<ResponseResult<?>> addProduct(ActivitySaveDTO activitySaveDTO) {
        ProductSuggest productSuggestTemp = (ProductSuggest)this.productSuggestDAO.findById((Object)activitySaveDTO.getIdPlatform()).orElseThrow(() -> new RuntimeException("PRODUCT NOT FOUND"));
        Purchase purchaseFind = this.purchaseDAO.findTopByConversationIdAndPlatformIdAndCompletedAndStatusOrderByIdDesc(productSuggestTemp.getIdConversation(), productSuggestTemp.getIdPlatform(), false, true).orElseGet(() -> {
            Purchase newPurchase = new Purchase();
            newPurchase.setPaymentMethod("Solo consultaba");
            newPurchase.setTotalAmount(Double.valueOf(0.0));
            newPurchase.setPlatformId(productSuggestTemp.getIdPlatform());
            newPurchase.setPlatform(productSuggestTemp.getPlatform());
            newPurchase.setConversationId(productSuggestTemp.getIdConversation());
            newPurchase.setUrlPurchase("");
            newPurchase.setPurchaseDetails(new ArrayList());
            return (Purchase)this.purchaseDAO.save((Object)newPurchase);
        });
        PurchaseType paymentMethod = PurchaseUtils.mapPaymentMethod((String)purchaseFind.getPaymentMethod());
        purchaseFind.getPurchaseDetails().stream().filter(detail -> productSuggestTemp.getProductId().equals(detail.getProductId())).findFirst().map(detail -> {
            detail.setQuantity(Integer.valueOf(detail.getQuantity() + 1));
            detail.setSubtotal(Double.valueOf((double)detail.getQuantity().intValue() * productSuggestTemp.getUnitPrice()));
            return detail;
        }).orElseGet(() -> {
            Long skuId = productSuggestTemp.getSkuId();
            Double priceProduct = 0.0;
            priceProduct = paymentMethod == PurchaseType.CREDIT ? this.mxVtexRepository.getPriceProductValue(skuId.intValue()) : productSuggestTemp.getUnitPrice();
            PurchaseDetail newDetail = new PurchaseDetail();
            newDetail.setProductId(productSuggestTemp.getProductId());
            newDetail.setSkuId(productSuggestTemp.getSkuId());
            newDetail.setQuantity(Integer.valueOf(1));
            newDetail.setUnitPrice(priceProduct);
            newDetail.setSubtotal(priceProduct);
            newDetail.setDescription(productSuggestTemp.getDescription());
            newDetail.setUrlImage(productSuggestTemp.getUrlImage());
            newDetail.setPurchase(purchaseFind);
            purchaseFind.getPurchaseDetails().add(newDetail);
            return newDetail;
        });
        double totalAmount = purchaseFind.getPurchaseDetails().stream().mapToDouble(PurchaseDetail::getSubtotal).sum();
        purchaseFind.setTotalAmount(Double.valueOf(totalAmount));
        this.purchaseDAO.save((Object)purchaseFind);
        return TransactionCustom.ok((String)"OK", (Object)ActivityResponseDTO.builder().message("\u2705 \u00a1Producto agregado a tu carrito!").hasEvent(Boolean.valueOf(true)).titleEvent("*Toque una de las opciones:*").events(Arrays.asList("VER_CARRITO", "COMPRAR")).build());
    }

    public ResponseEntity<ResponseResult<?>> finishPurchase(ActivitySaveDTO dto) {
        Optional findConversation = this.marcimexRepository.getConversationByIdentificationLast(dto.getIdPlatform());
        if (findConversation.isPresent()) {
            Conversacion conversacion = (Conversacion)findConversation.get();
            conversacion.setFinalizada(Boolean.valueOf(true));
            conversacion.setFechaCierre(LocalDateTime.now());
            this.conversacionDAO.save((Object)conversacion);
            log.info("Conversaci\u00f3n finalizada. idPlatform: {}, idConversacion: {}", (Object)dto.getIdPlatform(), (Object)conversacion.getId_conversacion());
        } else {
            log.warn("No se encontr\u00f3 conversaci\u00f3n activa para finalizar. idPlatform: {}", (Object)dto.getIdPlatform());
        }
        return this.createResponse("Gracias por confiar en *Marcimex*, fue un placer atenderte.\n\nMarcimex piensa en ti.", false, "", Collections.emptyList());
    }

    private ResponseEntity<ResponseResult<?>> createResponse(String message, boolean hasEvent, String titleEvent, List<String> events) {
        ActivityResponseDTO responseDTO = ActivityResponseDTO.builder().message(message).hasEvent(Boolean.valueOf(hasEvent)).titleEvent(titleEvent).events(events).build();
        return TransactionCustom.ok((String)"OK", (Object)responseDTO);
    }

    private ResponseEntity<ResponseResult<?>> validateActivity(ActivitySaveDTO dto) {
        if (dto.getActivity() == null || dto.getActivity().isBlank()) {
            log.warn("Empty activity in checkActivity. idPlatform: {}", (Object)dto.getIdPlatform());
            return ResponseEntity.badRequest().body((Object)new ResponseResult(false, StatusTransactions.error, "The activity cannot be empty", null));
        }
        return null;
    }

    private void logActivity(String idPlatform, String event, String productId) {
        log.info("idPlatform: {}, Evento detectado: {}{}", new Object[]{idPlatform, event, productId.isBlank() ? "" : String.format(", Producto: %s", productId)});
    }
}

