/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.facade;

import ec.tws2.back.lhia.marcimex.common.util.PurchaseUtils;
import ec.tws2.back.lhia.marcimex.common.util.TemplateUtil;
import ec.tws2.back.lhia.marcimex.infrastructure.async.LhiaConversationAsync;
import ec.tws2.back.lhia.marcimex.infrastructure.client.LhiaV3Client;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ConversacionDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.ProductSuggestDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.dao.PurchaseDAO;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MarcimexRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MxVtexRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ShortLinkRepository;
import ec.tws2.back.lhia.marcimex.models.data.ConversationResolution;
import ec.tws2.back.lhia.marcimex.models.data.LhiaRequest;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorial;
import ec.tws2.back.lhia.marcimex.models.data.ResponseRobot;
import ec.tws2.back.lhia.marcimex.models.entity.ProductSuggest;
import ec.tws2.back.lhia.marcimex.models.entity.Purchase;
import ec.tws2.back.lhia.marcimex.models.enums.PurchaseType;
import ec.tws2.back.lhia.marcimex.models.response.LhiaV3ApiResponse;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ProductFacade {
    private static final Logger log = LoggerFactory.getLogger(ProductFacade.class);
    private final ShortLinkRepository shortLinkRep;
    private final MxVtexRepository mxVtexRepository;
    private final MarcimexRepository marcimexRepository;
    private final PurchaseDAO purchaseDAO;
    private final ProductSuggestDAO productSuggestDAO;
    private final ConversacionDAO conversacionDAO;
    private final LhiaConversationAsync lhiaConversationAsync;
    private final LhiaV3Client lhiaV3Client;

    public ProductFacade(@Value(value="${lhia.domain.url}") String lhiaDomainUrl, MarcimexRepository marcimexRepository, ShortLinkRepository shortLinkRep, MxVtexRepository mxVtexRepository, PurchaseDAO purchaseDAO, ProductSuggestDAO productSuggestDAO, ConversacionDAO conversacionDAO, LhiaConversationAsync lhiaConversationAsync, LhiaV3Client lhiaV3Client) {
        this.marcimexRepository = marcimexRepository;
        this.shortLinkRep = shortLinkRep;
        this.mxVtexRepository = mxVtexRepository;
        this.purchaseDAO = purchaseDAO;
        this.productSuggestDAO = productSuggestDAO;
        this.conversacionDAO = conversacionDAO;
        this.lhiaConversationAsync = lhiaConversationAsync;
        this.lhiaV3Client = lhiaV3Client;
    }

    public ResponseRobot getLhiaProducts(@RequestBody LhiaRequest lhiaReq) {
        ResponseRobot responseBase = this.getResponseRobot(lhiaReq);
        ResponseRobot responseWithShortLinks = this.shortLinkRep.process(responseBase);
        ResponseRobot responseWithPrices = this.mxVtexRepository.getPriceProduct(responseWithShortLinks);
        ResponseRobot respTemplate = this.applyTemplates(responseWithPrices, lhiaReq);
        return respTemplate;
    }

    private ResponseRobot applyTemplates(ResponseRobot respRobot, LhiaRequest lhiaReq) {
        PurchaseType typePurchase = this.getTypePurchase(lhiaReq);
        respRobot.getListProductVectorial().forEach(item -> item.setTemplate(TemplateUtil.productTemplate((ProductVectorial)item, (PurchaseType)typePurchase)));
        return respRobot;
    }

    private ResponseRobot getResponseRobot(LhiaRequest lhiaReq) {
        log.info("Solicitud recibida en questionV2 ID: {}, Pregunta: {}", (Object)lhiaReq.getIdPlatform(), (Object)lhiaReq.getQuestion());
        ResponseRobot robot = this.marcimexRepository.findProductsByQuestion(lhiaReq);
        String response = robot.getResponse();
        String preview = response != null && !response.isBlank() ? (response.length() > 15 ? response.substring(0, 15) + "..." : response) : "Sin respuesta";
        int totalProd = Optional.ofNullable(robot.getListProductVectorial()).map(List::size).orElse(0);
        log.info("ID: {}, Productos encontrados: {}, Respuesta: {}", new Object[]{lhiaReq.getIdPlatform(), totalProd, preview});
        this.lhiaConversationAsync.saveMarkConversationAgent(preview, lhiaReq.getIdPlatform());
        return robot;
    }

    private PurchaseType getTypePurchase(LhiaRequest lhiaReq) {
        return this.marcimexRepository.getConversationByIdentificationLast(lhiaReq.getIdPlatform()).flatMap(item -> this.purchaseDAO.findTopByConversationIdAndPlatformIdAndCompletedAndStatusOrderByIdDesc(item.getIdentificador(), lhiaReq.getIdPlatform(), false, true)).map(Purchase::getPaymentMethod).map(PurchaseUtils::mapPaymentMethod).orElse(PurchaseType.ALL);
    }

    public ResponseRobot getLhiaProductsV3(LhiaRequest lhiaReq, String token) {
        LhiaV3ApiResponse.InnerData innerData;
        log.info("Solicitud recibida en questionV3 idPlatform: {}, platform: {}, Pregunta: {}", new Object[]{lhiaReq.getIdPlatform(), lhiaReq.getPlatform(), lhiaReq.getQuestion()});
        ConversationResolution resolution = this.marcimexRepository.resolveConversationUuidV3(lhiaReq.getIdentificador(), lhiaReq.getIdPlatform(), lhiaReq.getUsuario(), lhiaReq.getPlatform() != null ? lhiaReq.getPlatform().name() : null);
        String uuidConversation = resolution.getUuid();
        if ("FINALIZAR".equalsIgnoreCase(lhiaReq.getQuestion() != null ? lhiaReq.getQuestion().trim() : "")) {
            this.conversacionDAO.findByIdentificador(uuidConversation).ifPresent(conv -> {
                conv.setFinalizada(Boolean.valueOf(true));
                conv.setFechaCierre(LocalDateTime.now());
                this.conversacionDAO.save(conv);
                log.info("Conversacion finalizada: {}", (Object)uuidConversation);
            });
            ResponseRobot finish = new ResponseRobot();
            finish.setResponse("Gracias por confiar en *Marcimex*, fue un placer atenderte.\n\nMarcimex piensa en ti.");
            finish.setUuid(uuidConversation);
            finish.setListProductVectorial(Collections.emptyList());
            return finish;
        }
        String resumePurchase = "";
        if (resolution.isNew()) {
            resumePurchase = this.productSuggestDAO.findById((Object)lhiaReq.getIdPlatform()).map(ProductSuggest::getDescription).orElse("");
            log.info("Conversacion nueva para idPlatform={}, resumePurchase='{}'", (Object)lhiaReq.getIdPlatform(), (Object)resumePurchase);
        }
        if ((innerData = this.lhiaV3Client.searchProducts(uuidConversation, lhiaReq.getQuestion(), 6, resumePurchase, token)) == null) {
            log.error("Sin respuesta de LHIA V3 API para ID: {}", (Object)lhiaReq.getIdPlatform());
            ResponseRobot empty = new ResponseRobot();
            empty.setResponse("");
            empty.setListProductVectorial(Collections.emptyList());
            return empty;
        }
        if ("REDIRECCION_ASESOR".equalsIgnoreCase(innerData.getAnswer())) {
            this.conversacionDAO.findByIdentificador(uuidConversation).ifPresent(conv -> {
                conv.setFinalizada(Boolean.valueOf(true));
                conv.setFechaCierre(LocalDateTime.now());
                this.conversacionDAO.save(conv);
                log.info("Conversacion finalizada: {}", (Object)uuidConversation);
            });
        }
        List products = Optional.ofNullable(innerData.getProducts()).orElse(Collections.emptyList()).stream().map(arg_0 -> this.mapToProductVectorial(arg_0)).collect(Collectors.toList());
        ResponseRobot responseRobot = new ResponseRobot();
        responseRobot.setResponse(innerData.getAnswer());
        responseRobot.setUuid(uuidConversation);
        responseRobot.setListProductVectorial(products);
        log.info("ID: {}, Mapeados desde LHIA V3: {} productos", (Object)lhiaReq.getIdPlatform(), (Object)products.size());
        responseRobot = this.shortLinkRep.process(responseRobot);
        log.info("ID: {}, Tras shortLinks: {} productos", (Object)lhiaReq.getIdPlatform(), (Object)responseRobot.getListProductVectorial().size());
        responseRobot = this.mxVtexRepository.getPriceProduct(responseRobot);
        log.info("ID: {}, Tras precios: {} productos con creditInfo", (Object)lhiaReq.getIdPlatform(), (Object)responseRobot.getListProductVectorial().size());
        this.lhiaConversationAsync.saveMarkConversationAgent("", lhiaReq.getIdPlatform());
        PurchaseType typePurchase = this.getTypePurchase(lhiaReq);
        responseRobot.getListProductVectorial().forEach(item -> item.setTemplate(TemplateUtil.productTemplateV3((ProductVectorial)item, (PurchaseType)typePurchase)));
        return responseRobot;
    }

    private ProductVectorial mapToProductVectorial(LhiaV3ApiResponse.Product p) {
        ProductVectorial pv = new ProductVectorial();
        if (p.getProductId() != null) {
            try {
                pv.setId(Long.valueOf(Long.parseLong(p.getProductId())));
            }
            catch (NumberFormatException e) {
                log.warn("productId no es numerico desde LHIA V3: {}", (Object)p.getProductId());
            }
        }
        if (p.getSkuId() != null) {
            try {
                pv.setSkuId(Integer.parseInt(p.getSkuId()));
            }
            catch (NumberFormatException e) {
                log.warn("skuId no es numerico desde LHIA V3: {}", (Object)p.getSkuId());
            }
        }
        pv.setTitulo(p.getName());
        pv.setMarca(p.getBrand());
        pv.setCategoria(p.getCategory());
        pv.setLink(p.getLink());
        pv.setImagenUrl(p.getImage());
        pv.setDescripcion(p.getDescription());
        pv.setResumen(p.getSummary());
        pv.setCategoriaGlobal(p.getGlobalCategory());
        pv.setSubCategoria(p.getSubCategory());
        pv.setTipoProducto(p.getProductType());
        String rawPrice = p.getPrice();
        pv.setPrecio(rawPrice != null ? rawPrice.replace("USD", "").trim() : null);
        if (p.isPromotion()) {
            pv.setProductCategory("PROMOCION");
        } else {
            pv.setProductCategory("");
        }
        return pv;
    }
}

