/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.facade;

import ec.tws2.back.lhia.marcimex.infrastructure.client.MarcimexApiClient;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.PurchaseRepository;
import ec.tws2.back.lhia.marcimex.models.data.MarcimexOrderSummary;
import ec.tws2.back.lhia.marcimex.models.entity.Purchase;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MarcimexOrderFacade {
    private static final Logger log = LoggerFactory.getLogger(MarcimexOrderFacade.class);
    private final MarcimexApiClient marcimexApiClient;
    private final PurchaseRepository purchaseRepository;

    public MarcimexOrderFacade(MarcimexApiClient marcimexApiClient, PurchaseRepository purchaseRepository) {
        this.marcimexApiClient = marcimexApiClient;
        this.purchaseRepository = purchaseRepository;
    }

    public List<Purchase> getInvoicedOrdersExecute(LocalDate localDateFrom, LocalDate localDateTo) {
        return this.processInvoicedOrders(localDateFrom, localDateTo);
    }

    public List<Purchase> getYesterdayInvoicedOrdersExecute() {
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        return this.processInvoicedOrders(yesterday, today);
    }

    public List<Purchase> processInvoicedOrders(LocalDate localDateFrom, LocalDate localDateTo) {
        List apiData = this.marcimexApiClient.getInvoicedOrders(localDateFrom, localDateTo);
        log.info("Data List {}", (Object)apiData.size());
        List orderFormIds = this.getOrderFormIds(apiData);
        List existingPurchases = this.getExecutorBatchesPurchase(orderFormIds);
        Map invoicedByOrderFormId = this.buildInvoicedOrderMap(apiData);
        List purchasesToUpdate = this.updatePurchasesWithInvoiceData(existingPurchases, invoicedByOrderFormId);
        return this.purchaseRepository.saveAll(purchasesToUpdate);
    }

    private Map<String, MarcimexOrderSummary> buildInvoicedOrderMap(List<MarcimexOrderSummary> apiData) {
        return apiData.stream().collect(Collectors.toMap(MarcimexOrderSummary::getOrderFormId, Function.identity(), (existing, duplicate) -> existing));
    }

    private List<Purchase> updatePurchasesWithInvoiceData(List<Purchase> purchases, Map<String, MarcimexOrderSummary> invoicedMap) {
        return purchases.stream().map(purchase -> this.updateSinglePurchase(purchase, invoicedMap)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Purchase> updateSinglePurchase(Purchase purchase, Map<String, MarcimexOrderSummary> invoicedMap) {
        MarcimexOrderSummary invoiceData = invoicedMap.get(purchase.getOrderFormId());
        if (invoiceData == null) {
            log.warn("No se encontr\u00f3 data de API para orderFormId: {}", (Object)purchase.getOrderFormId());
            return Optional.empty();
        }
        purchase.setInvoiced(Boolean.valueOf(true));
        purchase.setOrderId(invoiceData.getOrderId());
        return Optional.of(purchase);
    }

    private List<String> getOrderFormIds(List<MarcimexOrderSummary> dataListApi) {
        List<String> orderFormIds = dataListApi.stream().map(MarcimexOrderSummary::getOrderFormId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return orderFormIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Purchase> getExecutorBatchesPurchase(List<String> orderFormIds) {
        int batchSize = 100;
        ArrayList<List<String>> batches = new ArrayList<List<String>>();
        for (int i = 0; i < orderFormIds.size(); i += batchSize) {
            batches.add(orderFormIds.subList(i, Math.min(i + batchSize, orderFormIds.size())));
        }
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(batches.size(), Runtime.getRuntime().availableProcessors()));
        try {
            List<Purchase> listPurchaseFind;
            List futures = batches.stream().map(batch -> CompletableFuture.supplyAsync(() -> {
                log.info("Procesando lote de {} IDs", (Object)batch.size());
                return this.purchaseRepository.findNotInvoicedByOrderFormIds(batch);
            }, executor)).collect(Collectors.toList());
            List<Purchase> list = listPurchaseFind = futures.stream().map(CompletableFuture::join).flatMap(Collection::stream).peek(purchase -> log.info("ID ITEM: {}", (Object)purchase.getId())).collect(Collectors.toList());
            return list;
        }
        finally {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

