/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.facade;

import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.LhiaRepository;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.OpenAiClientRepository;
import ec.tws2.back.lhia.marcimex.models.request.LhiaRequest;
import ec.tws2.back.lhia.marcimex.models.request.QuestionFlowRequest;
import ec.tws2.back.lhia.marcimex.models.request.QuestionRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ConversationFacade {
    private static final Logger log = LoggerFactory.getLogger(ConversationFacade.class);
    private final LhiaRepository lhiaRep;
    private final OpenAiClientRepository openAiClientRepo;

    public ConversationFacade(LhiaRepository lhiaRep, OpenAiClientRepository openAiClientRepo) {
        this.lhiaRep = lhiaRep;
        this.openAiClientRepo = openAiClientRepo;
    }

    public Map<String, Object> correctMessage(QuestionRequest request) {
        return this.openAiClientRepo.correctMessage(request);
    }

    public Map<String, Object> questionLhia(LhiaRequest request) {
        return this.openAiClientRepo.questionLhia(request);
    }

    public ResponseEntity<?> getQuestionFlow(QuestionFlowRequest request) {
        return this.lhiaRep.getQuestionFlow(request);
    }
}

