/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.dao;

import ec.tws2.back.lhia.marcimex.models.dto.VoucherDTO;
import ec.tws2.back.lhia.marcimex.models.entity.Voucher;
import java.util.Date;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface VoucherDAO
extends JpaRepository<Voucher, Long> {
    @Query(value="SELECT new ec.tws2.back.lhia.marcimex.models.dto.VoucherDTO(v.id, v.conversationId, v.description, v.nameFile, v.valid, v.totalTokens, v.idSubscription, v.createdAt,v.lastName,v.firstName,v.identification,c.numero_celular) FROM Voucher v JOIN Conversacion c ON v.conversationId = c.identificador WHERE v.createdAt >= :startDate AND v.createdAt <= :endDate ORDER BY v.id ASC")
    public Page<VoucherDTO> findVouchersForDays(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2, Pageable var3);

    @Query(value="SELECT new ec.tws2.back.lhia.marcimex.models.dto.VoucherDTO(v.id, v.conversationId, v.description, CONCAT(:baseUrl, v.nameFile), v.valid, v.totalTokens, v.idSubscription, v.createdAt,v.lastName,v.firstName,v.identification, c.numero_celular) FROM Voucher v JOIN Conversacion c ON v.conversationId = c.identificador ORDER BY v.id ASC")
    public Page<VoucherDTO> findVouchers(@Param(value="baseUrl") String var1, Pageable var2);

    @Query(value="SELECT COUNT(v) FROM Voucher v WHERE v.createdAt BETWEEN :startDate AND :endDate")
    public Long countByCreatedAtBetween(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2);

    @Query(value="SELECT COUNT(v) FROM Voucher v WHERE v.totalTokens > 0 AND v.createdAt BETWEEN :startDate AND :endDate")
    public Long countByCreatedAtBetweenAndTotalTokens(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2);
}

