/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.dao;

import ec.tws2.back.lhia.marcimex.models.entity.Purchase;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseByPaymentMethodProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseDailySummaryProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseHourRangeProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.RedirectSummaryProjection;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PurchaseDAO
extends JpaRepository<Purchase, Long> {
    @Query(value="SELECT p FROM Purchase p WHERE p.createdAt >= :startDate AND p.createdAt <= :endDate ORDER BY p.id ASC")
    public Page<Purchase> findListPurchase(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2, Pageable var3);

    public Optional<Purchase> findTopByConversationIdAndPlatformIdAndCompletedAndStatusOrderByIdDesc(String var1, String var2, boolean var3, boolean var4);

    public Optional<Purchase> findTopByPlatformIdAndCompletedAndStatusOrderByIdDesc(String var1, boolean var2, boolean var3);

    @Query(value="SELECT COALESCE(SUM(total_amount), 0)\nFROM lhia_marcimex.t_purchase\nWHERE url_purchase IS NOT NULL\n  AND TRIM(url_purchase) <> ''\n  AND created_at >= :startDate\n  AND created_at < :endDate\n", nativeQuery=true)
    public BigDecimal getTotalAmountBetweenDates(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2);

    @Query(value="SELECT COUNT(id)\nFROM lhia_marcimex.t_purchase\nWHERE url_purchase IS NOT NULL\n  AND TRIM(url_purchase) <> ''\n  AND created_at >= :startDate\n  AND created_at < :endDate\n", nativeQuery=true)
    public Long getCountBetweenDates(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2);

    @Query(value="SELECT p FROM Purchase p WHERE p.createdAt BETWEEN :start AND :end")
    public List<Purchase> findAllInRange(@Param(value="start") LocalDateTime var1, @Param(value="end") LocalDateTime var2);

    @Query(value="    SELECT\n      CASE\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 0 AND 5 THEN 'DAWN'\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 6 AND 11 THEN 'MORNING'\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 12 AND 17 THEN 'AFTERNOON'\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 18 AND 23 THEN 'NIGHT'\n      END AS timeSlot,\n\n      CASE\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 0 AND 5 THEN '00:00\u201305:59'\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 6 AND 11 THEN '06:00\u201311:59'\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 12 AND 17 THEN '12:00\u201317:59'\n        WHEN EXTRACT(HOUR FROM created_at) BETWEEN 18 AND 23 THEN '18:00\u201323:59'\n      END AS timeRange,\n\n      COUNT(*) FILTER (WHERE status = true) AS totalStarted,\n      COUNT(*) FILTER (WHERE status = true AND completed = true) AS totalCompleted,\n      COUNT(*) FILTER (WHERE status = true AND completed = false) AS totalNotCompleted\n    FROM lhia_marcimex.t_purchase\n    WHERE created_at BETWEEN :startDate AND :endDate\n    GROUP BY timeSlot, timeRange\n    ORDER BY timeSlot\n", nativeQuery=true)
    public List<PurchaseHourRangeProjection> getPurchasesByHourRange(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2);

    @Query(value="    SELECT\n    DATE(created_at) AS date,\n    COUNT(*) AS totalStarted,\n    SUM(total_amount) AS totalAmount\n    FROM lhia_marcimex.t_purchase\n    WHERE created_at BETWEEN :startDate AND :endDate\n    GROUP BY date\n    ORDER BY date\n", nativeQuery=true)
    public List<PurchaseDailySummaryProjection> getDailySummaryProjection(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2);

    @Query(value="  SELECT\n    payment_method AS paymentMethod,\n    COUNT(*) AS totalPurchases\n  FROM lhia_marcimex.t_purchase\n  WHERE created_at BETWEEN :startDate AND :endDate\n  GROUP BY payment_method\n  ORDER BY totalPurchases DESC\n", nativeQuery=true)
    public List<PurchaseByPaymentMethodProjection> getPurchasesByPaymentMethod(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2);

    @Query(value="  SELECT\n    COUNT(*) AS totalPurchase,\n    COUNT(DISTINCT tp.id) FILTER (\n      WHERE EXISTS (\n        SELECT 1\n        FROM lhia_marcimex.t_conversacion tc\n        JOIN lhia_marcimex.t_conversacion_detalle tcd\n          ON tcd.id_conversacion = tc.id_conversacion\n        WHERE tc.identificador = tp.conversation_id\n          AND tcd.mensaje = 'REDIRECT_ASESOR'\n      )\n    ) AS purchaseWithRedirectAsesor\n  FROM lhia_marcimex.t_purchase tp\n  WHERE tp.created_at BETWEEN :startDate AND :endDate\n", nativeQuery=true)
    public RedirectSummaryProjection getRedirectConversationToAsesor(@Param(value="startDate") LocalDateTime var1, @Param(value="endDate") LocalDateTime var2);

    @Query(value="SELECT p\nFROM Purchase p\nWHERE p.orderFormId = :orderFormId\n  AND p.invoiced = false\n")
    public Optional<Purchase> findNotInvoicedByOrderFormId(@Param(value="orderFormId") String var1);

    @Query(value="SELECT p FROM Purchase p WHERE p.orderFormId IN :orderFormIds AND p.invoiced = false")
    public List<Purchase> findNotInvoicedByOrderFormIds(@Param(value="orderFormIds") List<String> var1);

    public List<Purchase> findByPlatformId(String var1);
}

