/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.dao;

import ec.tws2.back.lhia.marcimex.models.entity.ConversacionDetalle;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ConversacionDetalleDAO
extends JpaRepository<ConversacionDetalle, Long> {
    @Query(value="select sum(cd.tokens) from ConversacionDetalle cd where cd.fecha >= :fecha1 and cd.fecha <= :fecha2")
    public String obtenerTokens(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2);

    @Query(value="select cd from ConversacionDetalle cd where cd.id_conversacion.identificador = :identificador order by cd.id_conversacion_detalle DESC limit 1")
    public List<ConversacionDetalle> obtenerConversacion(@Param(value="identificador") String var1);

    @Query(value="SELECT COUNT(DISTINCT cd.id_conversacion) FROM ConversacionDetalle cd WHERE FUNCTION('DATE', cd.fecha) BETWEEN :startDate AND :endDate")
    public Long countConversationsWithLhia(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2);

    @Query(value="SELECT cd FROM ConversacionDetalle cd WHERE cd.id_conversacion.id_conversacion IN :ids ORDER BY cd.fecha ASC")
    public List<ConversacionDetalle> findAllByConversacionIds(@Param(value="ids") List<Long> var1);
}

