/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.dao;

import ec.tws2.back.lhia.marcimex.models.data.UsuariosConsumo;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ConversacionDAO
extends JpaRepository<Conversacion, Long> {
    @Query(value="select tr.id AS id, tr.descripcion as rol, count( distinct tc.*) as usuarios from t_conversacion tc, t_roles tr  where tc.id_roles=tr.id and tc.fecha >= :fecha1 and tc.fecha <= :fecha2 group by  tr.id ORDER BY usuarios desc", nativeQuery=true)
    public List<UsuariosConsumo> listadoUsuarios(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2);

    public boolean existsByIdentificador(String var1);

    public boolean existsByIdentificadorAndFinalizadaFalseAndFechaAfter(String var1, Date var2);

    public Optional<Conversacion> findByIdentificador(String var1);

    @Query(value="SELECT c FROM Conversacion c WHERE c.numero_celular LIKE :numeroCelular ORDER BY c.id_conversacion DESC")
    public Page<Conversacion> findLastByNumeroCelular(@Param(value="numeroCelular") String var1, Pageable var2);

    @Query(value="SELECT c FROM Conversacion c WHERE c.numero_celular LIKE :numeroCelular AND c.canal LIKE :canal  ORDER BY c.id_conversacion DESC")
    public Page<Conversacion> findHistoryConversation(@Param(value="numeroCelular") String var1, @Param(value="canal") String var2, Pageable var3);

    @Query(value="SELECT COUNT(DISTINCT c.numero_celular) FROM Conversacion c WHERE c.fecha BETWEEN :startDate AND :endDate")
    public Long getUniqueUserCount(@Param(value="startDate") Date var1, @Param(value="endDate") Date var2);

    @Query(value="SELECT c.numero_celular FROM Conversacion c WHERE c.numero_celular IS NOT NULL AND c.numero_celular <> '' GROUP BY c.numero_celular ORDER BY MAX(c.fecha) DESC")
    public Page<String> findDistinctNumeroCelular(Pageable var1);

    @Query(value="SELECT c FROM Conversacion c WHERE c.numero_celular = :numeroCelular ORDER BY c.fecha DESC")
    public List<Conversacion> findAllByNumeroCelular(@Param(value="numeroCelular") String var1);

    @Query(value="\tSELECT c\n\tFROM Conversacion c\n\tWHERE c.numero_celular = :numeroCelular\n\tAND c.fecha >= :fechaDesde\n\tAND c.finalizada = false\n\tORDER BY c.fecha DESC\n")
    public Page<Conversacion> findLastByNumeroCelularSince(@Param(value="numeroCelular") String var1, @Param(value="fechaDesde") Date var2, Pageable var3);
}

