/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.dao;

import ec.tws2.back.lhia.marcimex.models.dto.CampaignWithCanalDTO;
import ec.tws2.back.lhia.marcimex.models.entity.TCampaignTag;
import ec.tws2.back.lhia.marcimex.models.projection.TagReportProjection;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CampaignTagDAO
extends JpaRepository<TCampaignTag, Integer> {
    public boolean existsByName(String var1);

    public Optional<TCampaignTag> findByNameAndActiveTrue(String var1);

    @Query(value="SELECT t FROM TCampaignTag t WHERE t.active = true AND LOWER(t.name) LIKE LOWER(CONCAT('%', :name, '%'))")
    public Optional<TCampaignTag> findByNameContainingAndActiveTrue(@Param(value="name") String var1);

    @Query(value="SELECT *\nFROM lhia_marcimex.t_campaign_tags tct\nWHERE tct.active = true\n  AND LOWER(:input) LIKE CONCAT('%', LOWER(tct.name), '%')\nORDER BY LENGTH(tct.name) DESC\nLIMIT 1\n", nativeQuery=true)
    public Optional<TCampaignTag> findMostRelevantByName(@Param(value="input") String var1);

    @Query(value="    SELECT new ec.tws2.back.lhia.marcimex.models.dto.CampaignWithCanalDTO(\n        ct.id, ct.name, ct.description, ca.name, ct.active\n    )\n    FROM TCampaignTag ct\n    JOIN ct.canal ca\n    ORDER BY ct.id DESC\n")
    public List<CampaignWithCanalDTO> findCampaignsWithCanal();

    @Query(value="SELECT ct.name AS name, COUNT(*) AS total\nFROM lhia_marcimex.t_user_tag ut\nJOIN lhia_marcimex.t_campaign_tags ct ON ct.id = ut.tag_id\nWHERE ut.created_at BETWEEN :startDate AND :endDate\nGROUP BY ct.id, ct.name\nORDER BY total DESC\n", nativeQuery=true)
    public List<TagReportProjection> getTagReport(@Param(value="startDate") LocalDate var1, @Param(value="endDate") LocalDate var2);
}

