/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ShortLinkRepository;
import ec.tws2.back.lhia.marcimex.models.entity.ShortLink;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/s"})
public class ShortLinkController {
    private final ShortLinkRepository service;

    @PostMapping
    public ResponseEntity<Map<String, String>> create(@RequestBody Map<String, String> request) {
        String originalUrl = request.get("url");
        ShortLink shortLink = this.service.createShortLink(originalUrl);
        String shortUrl = "https://api.tuback.com/s/" + shortLink.getCode();
        return ResponseEntity.ok(Map.of("shortUrl", shortUrl, "code", shortLink.getCode(), "originalUrl", originalUrl));
    }

    @GetMapping(value={"/{code}"})
    public void redirect(@PathVariable String code, HttpServletResponse response) throws IOException {
        this.service.getOriginalUrl(code).ifPresentOrElse(url -> {
            try {
                response.sendRedirect(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, () -> {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Link not found");
        });
    }

    public ShortLinkController(ShortLinkRepository service) {
        this.service = service;
    }
}

