/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import ec.tws2.back.lhia.marcimex.infrastructure.facade.PurchaseFacade;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.PurchaseRepository;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.dto.ActivitySaveDTO;
import ec.tws2.back.lhia.marcimex.models.entity.Purchase;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.util.Date;
import org.springframework.data.domain.Page;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"purchase"})
public class PurchaseController {
    private PurchaseRepository purchaseRepository;
    private PurchaseFacade purchaseFacade;

    @PostMapping(value={"save"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<ResponseResult<?>> save(@RequestBody Purchase purchase) {
        return this.purchaseRepository.save(purchase);
    }

    @PostMapping(value={"listPurchases"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public Page<Purchase> getPurchases(@RequestParam(required=true) @DateTimeFormat(pattern="yyyy-MM-dd") Date startDate, @RequestParam(required=true) @DateTimeFormat(pattern="yyyy-MM-dd") Date endDate, @RequestParam int page, @RequestParam int size) {
        return this.purchaseRepository.findListPurchase(startDate, endDate, page, size);
    }

    @PostMapping(value={"saveActivity"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<ResponseResult<?>> saveActivity(@RequestBody ActivitySaveDTO activitySaveDTO, HttpServletRequest httpRequest) {
        String token = httpRequest.getHeader("Authorization");
        return this.purchaseRepository.saveActivity(activitySaveDTO, token);
    }

    @PostMapping(value={"checkActivity"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<ResponseResult<?>> checkActivity(@RequestBody ActivitySaveDTO activitySaveDTO, HttpServletRequest httpRequest) {
        String token = httpRequest.getHeader("Authorization");
        return this.purchaseFacade.checkActivity(activitySaveDTO, token);
    }

    @PostMapping(value={"amountCartGenerate"}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="hasRole('user')")
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<?> getDocumentsHistory(@RequestParam(value="startDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(value="endDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        return this.purchaseRepository.getTotalAmountBetweenDates(startDate, endDate);
    }

    @PostMapping(value={"countCartGenerate"}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="hasRole('user')")
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<?> countCartGenerate(@RequestParam(value="startDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(value="endDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        return this.purchaseRepository.getCountBetweenDates(startDate, endDate);
    }

    public PurchaseController(PurchaseRepository purchaseRepository, PurchaseFacade purchaseFacade) {
        this.purchaseRepository = purchaseRepository;
        this.purchaseFacade = purchaseFacade;
    }
}

