/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import ec.tws2.back.lhia.marcimex.infrastructure.facade.ProductFacade;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.MarcimexRepository;
import ec.tws2.back.lhia.marcimex.models.data.DatosEntrenados;
import ec.tws2.back.lhia.marcimex.models.data.LhiaRequest;
import ec.tws2.back.lhia.marcimex.models.data.ResponseRobot;
import ec.tws2.back.lhia.marcimex.models.data.TemasConsumo;
import ec.tws2.back.lhia.marcimex.models.data.UsuariosConsumo;
import ec.tws2.back.lhia.marcimex.models.entity.Actividad;
import jakarta.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marcimex"})
@CrossOrigin(origins={"*"}, allowedHeaders={"*"})
public class ProductController {
    private static final Logger log = LoggerFactory.getLogger(ProductController.class);
    @Autowired
    MarcimexRepository marcimexRepository;
    @Autowired
    ProductFacade productFacade;

    @PostMapping(value={"/questionV2"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public ResponseRobot getProduct(@RequestBody LhiaRequest customer) {
        return this.productFacade.getLhiaProducts(customer);
    }

    @PostMapping(value={"/questionV3"}, consumes={"application/json"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public ResponseRobot getProductV3(@RequestBody LhiaRequest customer, HttpServletRequest httpRequest) {
        String token = httpRequest.getHeader("Authorization");
        return this.productFacade.getLhiaProductsV3(customer, token);
    }

    @GetMapping(value={"/generaNumTokens"})
    public void generaNumTokens() {
        this.marcimexRepository.generateNumTokens();
    }

    @PostMapping(value={"/lista/conversacion/tokens"}, produces={"application/json"})
    public int obtenerTokens(@RequestParam Date fecha1, Date fecha2) {
        return this.marcimexRepository.obtenerTokens(fecha1, fecha2);
    }

    @PostMapping(value={"/lista/documentos/datosEntrenados"}, produces={"application/json"})
    public List<DatosEntrenados> obtenerDatosEntrenados() {
        ArrayList<DatosEntrenados> listDataTrained = new ArrayList<DatosEntrenados>();
        listDataTrained.add(new DatosEntrenados("chats", "Estas son el total de datos entrenados", 10, "pi-list"));
        listDataTrained.add(new DatosEntrenados("opciones", "Estas son el total de datos de direcciones", 10, "pi-list"));
        listDataTrained.add(new DatosEntrenados("direcciones", "Estas son el total de datos de direcciones", 10, "pi-list"));
        return listDataTrained;
    }

    @PostMapping(value={"/lista/rol/usuarios"}, produces={"application/json"})
    public List<UsuariosConsumo> obtenerlistadoUsuarios(@RequestParam Date fecha1, Date fecha2) {
        return this.marcimexRepository.obtenerlistadoUsuarios(fecha1, fecha2);
    }

    @PostMapping(value={"/lista/calificaciones"}, produces={"application/json"})
    public List<Map<String, Object>> obtenerCalificaciones() {
        ArrayList<Map<String, Object>> calificaciones = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> calificacion1 = new HashMap<String, Object>();
        calificacion1.put("id", 1);
        calificacion1.put("calificacion", "BUENA");
        calificacion1.put("frecuencia", 20);
        calificaciones.add(calificacion1);
        HashMap<String, Object> calificacion2 = new HashMap<String, Object>();
        calificacion2.put("id", 2);
        calificacion2.put("calificacion", "MALA");
        calificacion2.put("frecuencia", 1);
        calificaciones.add(calificacion2);
        return calificaciones;
    }

    @PostMapping(value={"/conversacion/inicio"}, produces={"application/json"})
    public ResponseEntity<?> conversacionInicio(@RequestParam String identificador, @RequestParam String usuario, @RequestParam String numero_celular, @RequestParam String canal, @RequestParam String rol) {
        return this.marcimexRepository.startConversacion(identificador, usuario, numero_celular, canal, rol);
    }

    @PostMapping(value={"/conversacion/actividad"}, consumes={"text/plain"})
    public ResponseEntity<?> conversacionActividad(@RequestParam String identificador, @RequestParam Long opcion, @RequestParam String pregunta, @RequestBody String respuesta) {
        return this.marcimexRepository.actividadConversacion(identificador, opcion, pregunta, respuesta);
    }

    @PostMapping(value={"/lista/temas"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<TemasConsumo> obtenerPreguntas(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.marcimexRepository.obtenerTemas(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/lista/preguntas"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<Actividad> listadoActividadCarpetas(@RequestParam Long id, Date fecha1, Date fecha2) throws ParseException, InterruptedException, ExecutionException {
        return this.marcimexRepository.listadoActividadOpciones(id, fecha1, fecha2);
    }

    @PostMapping(value={"/lista/preguntas/paginado"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public Page<Actividad> listadoActividadOpcionesPaginado(@RequestParam Long id, Date fecha1, Date fecha2, int pagina, int filas) throws ParseException, InterruptedException, ExecutionException {
        return this.marcimexRepository.listadoActividadOpcionesPaginado(id, fecha1, fecha2, pagina, filas);
    }
}

