/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import ec.tws2.back.lhia.marcimex.infrastructure.facade.ConversationFacade;
import ec.tws2.back.lhia.marcimex.models.request.LhiaRequest;
import ec.tws2.back.lhia.marcimex.models.request.QuestionFlowRequest;
import ec.tws2.back.lhia.marcimex.models.request.QuestionRequest;
import jakarta.validation.Valid;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lhia"})
public class LhiaController {
    private final ConversationFacade conversationFacade;

    @PostMapping(value={"/smartCorrection"})
    @CrossOrigin
    public Map<String, Object> correctMessage(@Valid @ModelAttribute QuestionRequest request) {
        return this.conversationFacade.correctMessage(request);
    }

    @PostMapping(value={"/question"})
    @CrossOrigin
    public Map<String, Object> questionLhia(@RequestBody LhiaRequest request) {
        return this.conversationFacade.questionLhia(request);
    }

    @PostMapping(value={"/questionFlow"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> getQuestionFlow(@RequestBody QuestionFlowRequest request) {
        return this.conversationFacade.getQuestionFlow(request);
    }

    public LhiaController(ConversationFacade conversationFacade) {
        this.conversationFacade = conversationFacade;
    }
}

