/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.DocumentFileRepository;
import ec.tws2.back.lhia.marcimex.models.entity.DocumentFile;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"document-file"})
public class DocumentFileController {
    private DocumentFileRepository documentFileRepository;

    @GetMapping(value={"/image/{name}"})
    public ResponseEntity<byte[]> getImage(@PathVariable String name) {
        Optional documentFile = this.documentFileRepository.findByName(name);
        if (documentFile.isPresent()) {
            HttpHeaders headers = new HttpHeaders();
            String fileType = this.determineImageType(((DocumentFile)documentFile.get()).getFileData());
            if (fileType == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            headers.setContentType(MediaType.parseMediaType((String)fileType));
            return new ResponseEntity((Object)((DocumentFile)documentFile.get()).getFileData(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private String determineImageType(byte[] imageBytes) {
        if (imageBytes.length > 4 && imageBytes[0] == -119 && imageBytes[1] == 80 && imageBytes[2] == 78 && imageBytes[3] == 71) {
            return "image/png";
        }
        if (imageBytes.length > 3 && imageBytes[0] == -1 && imageBytes[1] == -40 && imageBytes[2] == -1) {
            return "image/jpeg";
        }
        return null;
    }

    public DocumentFileController(DocumentFileRepository documentFileRepository) {
        this.documentFileRepository = documentFileRepository;
    }
}

