/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ConversationRepository;
import ec.tws2.back.lhia.marcimex.models.data.ConversationHistory;
import ec.tws2.back.lhia.marcimex.models.data.ResponseResult;
import ec.tws2.back.lhia.marcimex.models.request.StartConversationRequest;
import java.util.Date;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"conversation"})
public class ConversationController {
    private ConversationRepository conversationRepository;

    @PostMapping(value={"history"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<ResponseResult<?>> getHistoryConversation(@RequestBody ConversationHistory conversationHistory) {
        return this.conversationRepository.getIdentificationLastConversationHistory(conversationHistory);
    }

    @PostMapping(value={"uniqueUserCount"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public Map<String, Long> getLastSubscription(@RequestParam(name="fecha1", required=false) Date date1, @RequestParam(name="fecha2", required=false) Date date2) {
        return this.conversationRepository.getUniqueUserCount(date1, date2);
    }

    @PostMapping(value={"/start"}, produces={"application/json"})
    public ResponseEntity<?> conversacionStart(@RequestBody StartConversationRequest request) {
        return this.conversationRepository.startConversacion(request);
    }

    public ConversationController(ConversationRepository conversationRepository) {
        this.conversationRepository = conversationRepository;
    }
}

