/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ClienteRepository;
import ec.tws2.back.lhia.marcimex.models.dto.ClienteListaDTO;
import ec.tws2.back.lhia.marcimex.models.dto.ClienteResumenDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/clientes"})
public class ClienteController {
    @Autowired
    private ClienteRepository clienteRepository;

    @GetMapping
    public ResponseEntity<Page<ClienteListaDTO>> listarClientes(@RequestParam(defaultValue="0") int pagina, @RequestParam(defaultValue="20") int tamano) {
        PageRequest pageable = PageRequest.of((int)pagina, (int)tamano);
        return ResponseEntity.ok((Object)this.clienteRepository.obtenerListadoClientes((Pageable)pageable));
    }

    @GetMapping(value={"/{telefono}"})
    public ResponseEntity<ClienteResumenDTO> obtenerDetalleCliente(@PathVariable String telefono) {
        ClienteResumenDTO detalle = this.clienteRepository.obtenerDetalleCliente(telefono);
        if (detalle == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)detalle);
    }
}

