/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import ec.tws2.back.lhia.marcimex.infrastructure.service.export.CsvExportService;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.CampaignRepository;
import ec.tws2.back.lhia.marcimex.models.request.CampaignTagRequest;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"campaign"})
public class CampaignController {
    private final CampaignRepository campaignRepository;
    private final CsvExportService csvExportService;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");

    @GetMapping(value={"/canals"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> getCanalsActives() {
        return this.campaignRepository.findCanalsActive();
    }

    @PostMapping(value={"/create"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> createCampaign(@RequestBody CampaignTagRequest request) {
        return this.campaignRepository.createCampaign(request);
    }

    @PutMapping(value={"/{id}/status"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> disableCampaign(@PathVariable Integer id, @RequestBody Map<String, Boolean> status) {
        Boolean active = status.get("active");
        return this.campaignRepository.changeStatusCampaign(id, active);
    }

    @GetMapping(value={"/campaignsWithCanal"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> getCampaignsWithCanal() {
        return this.campaignRepository.findCampaignsWithCanal();
    }

    @PostMapping(value={"/findTagsCampaign"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> findTagsCampaign(@RequestParam(value="startDate", required=false) String startDateStr, @RequestParam(value="endDate", required=false) String endDateStr, Pageable pageable) {
        return this.campaignRepository.findTagsCampaign(pageable, this.parseDate(startDateStr), this.parseDate(endDateStr));
    }

    @PostMapping(value={"/tagReport"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> getTagReport(@RequestParam(value="startDate", required=false) String startDateStr, @RequestParam(value="endDate", required=false) String endDateStr, Pageable pageable) {
        return this.campaignRepository.getTagReport(this.parseDate(startDateStr), this.parseDate(endDateStr));
    }

    @GetMapping(value={"/findTagsCampaign/export-csv"}, produces={"text/csv"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public void exportToCSV(@RequestParam(value="startDate", required=false) String startDateStr, @RequestParam(value="endDate", required=false) String endDateStr, HttpServletResponse response) throws IOException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        response.setContentType("text/csv; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=TagsCampaign.csv");
        ServletOutputStream outputStream = response.getOutputStream();
        byte[] bom = new byte[]{-17, -69, -65};
        outputStream.write(bom);
        List reports = this.campaignRepository.findTagsCampaignCSV(this.parseDate(startDateStr), this.parseDate(endDateStr));
        this.csvExportService.exportTagsCampaignCsv(reports, (OutputStream)response.getOutputStream());
    }

    private LocalDate parseDate(String dateStr) {
        try {
            return dateStr != null ? LocalDateTime.parse(dateStr, DATE_TIME_FORMATTER).toLocalDate() : null;
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Formato de fecha inv\u00e1lido: " + dateStr);
        }
    }

    public CampaignController(CampaignRepository campaignRepository, CsvExportService csvExportService) {
        this.campaignRepository = campaignRepository;
        this.csvExportService = csvExportService;
    }
}

