/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.controller;

import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import ec.tws2.back.lhia.marcimex.infrastructure.service.export.CsvExportService;
import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.PurchaseStatsRepository;
import ec.tws2.back.lhia.marcimex.models.dto.PurchaseStatsDTO;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseByPaymentMethodProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseDailySummaryProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.PurchaseHourRangeProjection;
import ec.tws2.back.lhia.marcimex.models.interfaces.RedirectSummaryProjection;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/analytics-report"})
public class AnalyticsReportController {
    private final PurchaseStatsRepository repository;
    private final CsvExportService csvExportService;

    @PostMapping(value={"/totalPurchasesStarted"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<PurchaseStatsDTO> getTotalPurchasesStarted(@RequestParam(value="startDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(value="endDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        PurchaseStatsDTO responseData = this.repository.getTotalPurchasesStarted(startDate, endDate);
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping(value={"/totalPurchases"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> getTotalPurchases(@RequestParam(value="startDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(value="endDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        List responseData = this.repository.getTotalPurchases(startDate, endDate);
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping(value={"/purchasesByHourRange"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<List<PurchaseHourRangeProjection>> getPurchasesByHourRange(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        List responseData = this.repository.getPurchasesByHourRange(startDate, endDate);
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping(value={"/dailySummaryProjection"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<List<PurchaseDailySummaryProjection>> getDailySummaryProjection(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        List responseData = this.repository.getDailySummaryProjection(startDate, endDate);
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping(value={"/purchasesByPaymentMethod"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<List<PurchaseByPaymentMethodProjection>> getPurchasesByPaymentMethod(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        List responseData = this.repository.getPurchasesByPaymentMethod(startDate, endDate);
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping(value={"/redirectConversationCartToAsesor"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<RedirectSummaryProjection> getRedirectConversationToAsesor(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        RedirectSummaryProjection responseData = this.repository.getRedirectConversationToAsesor(startDate, endDate);
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping(value={"/findUserPurchaseItem"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> findUserPurchaseItem(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, Pageable pageable) {
        Page responseData = this.repository.findUserPurchaseItem(startDate, endDate, pageable);
        return ResponseEntity.ok((Object)responseData);
    }

    @PostMapping(value={"/findUserPurchaseItemCSV"}, consumes={"application/x-www-form-urlencoded"}, produces={"text/csv"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public void exportToCSV(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, HttpServletResponse response) throws IOException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        response.setContentType("text/csv; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=user_purchase_item.csv");
        List reports = this.repository.findUserPurchaseCSV(startDate, endDate);
        this.csvExportService.exportUserConversationCartItemCsv(reports, (OutputStream)response.getOutputStream());
    }

    public AnalyticsReportController(PurchaseStatsRepository repository, CsvExportService csvExportService) {
        this.repository = repository;
        this.csvExportService = csvExportService;
    }
}

