/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.client;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VtexApiClient {
    @Value(value="${vtex.api.appKey}")
    private String vtexApiAppKey;
    @Value(value="${vtex.api.appToken}")
    private String vtexApiAppToken;
    @Value(value="${vtex.api.url}")
    private String apiVtex;
    private static final String CONTENT_TYPE = "application/json";
    private final HttpClient httpClient = HttpClient.newHttpClient();

    public JSONObject initOrderForm(int typePurchase) throws Exception {
        URI uri = new URI(this.apiVtex + "/api/checkout/pub/orderForm?forceNewCart=true&sc=" + typePurchase);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", CONTENT_TYPE).header("X-VTEX-API-AppKey", this.vtexApiAppKey).header("X-VTEX-API-AppToken", this.vtexApiAppToken).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return new JSONObject(response.body());
    }

    public JSONObject addUTMOrderForm(String orderFormId) throws Exception {
        URI uri = new URI(this.apiVtex + "/api/checkout/pub/orderForm/" + orderFormId + "/attachments/marketingData");
        JSONObject dataSave = new JSONObject();
        dataSave.put("utmSource", (Object)"botIAmcx");
        dataSave.put("utmMedium", (Object)"whatsapp");
        dataSave.put("utmCampaign", (Object)"carritoGenerado");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", CONTENT_TYPE).header("X-VTEX-API-AppKey", this.vtexApiAppKey).header("X-VTEX-API-AppToken", this.vtexApiAppToken).POST(HttpRequest.BodyPublishers.ofString(dataSave.toString())).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return new JSONObject(response.body());
    }

    public JSONObject addItemCart(String orderFormId, List<JSONObject> orderItems, int typePurchase) throws Exception {
        URI uri = new URI(this.apiVtex + "/api/checkout/pub/orderForm/" + orderFormId + "/items?sc=" + typePurchase);
        JSONObject dataSave = new JSONObject();
        dataSave.put("orderItems", (Object)new JSONArray(orderItems));
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", CONTENT_TYPE).header("X-VTEX-API-AppKey", this.vtexApiAppKey).header("X-VTEX-API-AppToken", this.vtexApiAppToken).POST(HttpRequest.BodyPublishers.ofString(dataSave.toString())).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return new JSONObject(response.body());
    }
}

