/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.client;

import ec.tws2.back.lhia.marcimex.models.request.OpenAiRequest;
import ec.tws2.back.lhia.marcimex.models.response.OpenAiResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    @Value(value="${openai.apiKey}")
    private String apiKeyOpenAi;
    @Value(value="${openai.urlAnswer2}")
    private String urlOpenAi;
    @Value(value="${openai.modelAnswer2}")
    private String modelOpenAi;
    private final RestTemplate restTemplate = new RestTemplate();

    public OpenAiResponse getChatResponse(String fullPrompt, int maxTokens) {
        OpenAiRequest request = new OpenAiRequest(this.modelOpenAi, List.of(new OpenAiRequest.Message("system", fullPrompt)), maxTokens);
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(this.apiKeyOpenAi);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.urlOpenAi, HttpMethod.POST, entity, OpenAiResponse.class, new Object[0]);
            if (response.getBody() != null && !((OpenAiResponse)response.getBody()).getChoices().isEmpty()) {
                return (OpenAiResponse)response.getBody();
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error communicating with OpenAI:" + String.valueOf(e));
            return null;
        }
    }

    public OpenAiResponse getLhiaQuestion(List<OpenAiRequest.Message> listMessages, int maxTokens) {
        OpenAiRequest request = new OpenAiRequest(this.modelOpenAi, listMessages, maxTokens);
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(this.apiKeyOpenAi);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.urlOpenAi, HttpMethod.POST, entity, OpenAiResponse.class, new Object[0]);
            if (response.getBody() != null && !((OpenAiResponse)response.getBody()).getChoices().isEmpty()) {
                return (OpenAiResponse)response.getBody();
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error communicating with OpenAI:" + String.valueOf(e));
            return null;
        }
    }
}

