/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.client;

import ec.tws2.back.lhia.marcimex.models.dto.PricingLoadstoneDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class MxVtexApiClient {
    private static final Logger log = LoggerFactory.getLogger(MxVtexApiClient.class);
    private final RestTemplate restTemplate;

    public MxVtexApiClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public PricingLoadstoneDto getPricingLoadstone(int skuId) {
        String url = "https://www.marcimex.com/_v/pricing/loadstone/" + skuId;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.add("Cookie", "VtexWorkspace=master%3A-");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, entity, PricingLoadstoneDto.class, new Object[0]);
            if (resp == null || !resp.getStatusCode().is2xxSuccessful()) {
                log.warn("PricingLoadstone: respuesta nula o HTTP {} para skuId={}", resp != null ? resp.getStatusCode() : "null", (Object)skuId);
                return null;
            }
            PricingLoadstoneDto result = (PricingLoadstoneDto)resp.getBody();
            if (result != null) {
                log.info("PricingLoadstone skuId={}: pvpNormal={}, pvpOferta={}, totalAPagar={}, plazo={}, cuota={}", new Object[]{skuId, result.getNormalPrice(), result.getOfferPrice(), result.getTotalToPay(), result.getTerm(), result.getInstallment()});
            }
            return result;
        }
        catch (HttpStatusCodeException e) {
            log.warn("HTTP {} {} - body: {}", new Object[]{e.getStatusCode(), url, e.getResponseBodyAsString()});
            return null;
        }
        catch (ResourceAccessException e) {
            log.warn("Resource access error {}: {}", (Object)url, (Object)e.getMessage());
            return null;
        }
        catch (RestClientException e) {
            log.warn("Rest error {}: {}", (Object)url, (Object)e.getMessage());
            return null;
        }
    }
}

