/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.client;

import ec.tws2.back.lhia.marcimex.models.request.MetaMarciRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MetaMarciApiClient {
    private static final Logger log = LoggerFactory.getLogger(MetaMarciApiClient.class);
    @Value(value="${meta.marci.update-state-path}")
    private String updateStatePath;
    private final RestTemplate restTemplate = new RestTemplate();

    public boolean updateStateConversation(MetaMarciRequest request) {
        String url = "https://meta-marci.tws2.io/whatsapp/state/updateStateConversation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
            log.info("API Meta-Marci Status: {} | ID: {}", (Object)response.getStatusCode(), (Object)request.getConversationId());
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (Exception e) {
            log.error("Error al notificar API Meta-Marci: {}", (Object)e.getMessage());
            return false;
        }
    }
}

