/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.client;

import ec.tws2.back.lhia.marcimex.infrastructure.util.DateUtil;
import ec.tws2.back.lhia.marcimex.models.data.MarcimexOrderSummary;
import ec.tws2.back.lhia.marcimex.models.dto.MarcimexOrdersResponse;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;

@Service
public class MarcimexApiClient {
    private static final Logger log = LoggerFactory.getLogger(MarcimexApiClient.class);
    private static final String CATALOG_BASE_URL = "https://www.marcimex.com";
    private final RestTemplate catalogRestTemplate = new RestTemplate();
    private final RestClient restClient;
    private final String appKey;
    private final String appToken;

    public MarcimexApiClient(RestClient.Builder builder, @Value(value="${api.marcimex.base-url}") String baseUrl, @Value(value="${marcimex.app-key}") String appKey, @Value(value="${marcimex.app-token}") String appToken) {
        this.restClient = builder.baseUrl(baseUrl).build();
        this.appKey = appKey;
        this.appToken = appToken;
    }

    private MarcimexOrdersResponse getInvoicedOrdersPage(LocalDate fromDate, LocalDate toDate, int page, int perPage) {
        String filter = DateUtil.buildInvoicedDateFilter((LocalDate)fromDate, (LocalDate)toDate);
        long start = System.currentTimeMillis();
        log.info("Called to Marcimex Orders - page={}, perPage={}, fromDate={}, toDate={}, filter={}", new Object[]{page, perPage, fromDate, toDate, filter});
        ResponseEntity responseEntity = this.restClient.get().uri(uriBuilder -> uriBuilder.path("/api/oms/pvt/orders").queryParam("per_page", new Object[]{perPage}).queryParam("page", new Object[]{page}).queryParam("f_invoicedDate", new Object[]{filter}).build(new Object[0])).header("X-VTEX-API-AppToken", new String[]{this.appToken}).header("X-VTEX-API-AppKey", new String[]{this.appKey}).retrieve().toEntity(MarcimexOrdersResponse.class);
        long elapsed = System.currentTimeMillis() - start;
        MarcimexOrdersResponse body = (MarcimexOrdersResponse)responseEntity.getBody();
        int count = body != null && body.getList() != null ? body.getList().size() : 0;
        log.info("Respuesta Marcimex Orders - page={}, status={}, itemsEnLista={}, tiempoMs={}", new Object[]{page, responseEntity.getStatusCode(), count, elapsed});
        return body;
    }

    public List<MarcimexOrderSummary> getInvoicedOrders(LocalDate fromDate, LocalDate toDate) {
        MarcimexOrdersResponse response;
        int perPage = 100;
        int maxPages = 20;
        ArrayList<MarcimexOrderSummary> allOrders = new ArrayList<MarcimexOrderSummary>();
        for (int page = 1; page <= maxPages && (response = this.getInvoicedOrdersPage(fromDate, toDate, page, perPage)) != null && response.getList() != null && !response.getList().isEmpty(); ++page) {
            allOrders.addAll(response.getList());
            MarcimexOrdersResponse.Paging paging = response.getPaging();
            if (paging == null || paging.getPages() == null || page >= paging.getPages()) break;
            if (page != maxPages || paging.getPages() <= maxPages) continue;
            log.warn("Se alcanz\u00f3 el l\u00edmite de p\u00e1ginas ({}) para el rango {} - {}. Marcimex reporta un total de {} p\u00e1ginas, por lo que el resultado est\u00e1 truncado.", new Object[]{maxPages, fromDate, toDate, paging.getPages()});
            break;
        }
        return allOrders;
    }

    public String getProductInfo(String productId) {
        String url = "https://www.marcimex.com/api/catalog_system/pub/products/search?fq=productId:" + productId;
        try {
            ResponseEntity response = this.catalogRestTemplate.getForEntity(url, String.class, new Object[0]);
            return (String)response.getBody();
        }
        catch (Exception e) {
            log.error("Error getting product info from Marcimex catalog for productId={}: {}", (Object)productId, (Object)e.getMessage());
            return null;
        }
    }
}

