/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.client;

import ec.tws2.back.lhia.marcimex.models.request.LhiaV3ApiRequest;
import ec.tws2.back.lhia.marcimex.models.response.LhiaV3ApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class LhiaV3Client {
    private static final Logger log = LoggerFactory.getLogger(LhiaV3Client.class);
    @Value(value="${lhia.v3.url}")
    private String lhiaV3Url;
    private final RestTemplate restTemplate = new RestTemplate();

    public LhiaV3ApiResponse.InnerData searchProducts(String uuidConversation, String question, int count, String resumePurchase, String token) {
        LhiaV3ApiRequest request = new LhiaV3ApiRequest(uuidConversation, question, count, resumePurchase);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (token != null && !token.isBlank()) {
            headers.set("Authorization", token);
        }
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            String url = this.lhiaV3Url + "/chat/conversation";
            log.info("Llamando LHIA V3 API request: {}", (Object)request);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, LhiaV3ApiResponse.InnerData.class, new Object[0]);
            LhiaV3ApiResponse.InnerData body = (LhiaV3ApiResponse.InnerData)response.getBody();
            if (body == null) {
                log.warn("Respuesta vac\u00eda de LHIA V3 API");
                return null;
            }
            int totalProducts = body.getProducts() != null ? body.getProducts().size() : 0;
            log.info("LHIA V3 respuesta: intent={}, total={}, productos={}", new Object[]{body.getIntent(), body.getTotal(), totalProducts});
            if (body.getProducts() != null) {
                body.getProducts().forEach(p -> log.info("  [LHIA V3] productId={}, skuId={}, nombre='{}', precio={}, marca={}", new Object[]{p.getProductId(), p.getSkuId(), p.getName(), p.getPrice(), p.getBrand()}));
            }
            return body;
        }
        catch (Exception e) {
            log.error("Error al llamar LHIA V3 API: {}", (Object)e.getMessage());
            return null;
        }
    }

    public LhiaV3ApiResponse.Product getProductById(String productId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (token != null && !token.isBlank()) {
            headers.set("Authorization", token);
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String url = this.lhiaV3Url + "/products/" + productId;
        try {
            log.info("Llamando LHIA V3 API getProductById: {}", (Object)url);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, LhiaV3ApiResponse.Product.class, new Object[0]);
            LhiaV3ApiResponse.Product body = (LhiaV3ApiResponse.Product)response.getBody();
            log.info("Producto obtenido: productId={}, nombre='{}', precio={}", new Object[]{productId, body != null ? body.getName() : null, body != null ? body.getPrice() : null});
            return body;
        }
        catch (HttpClientErrorException.NotFound e) {
            log.warn("Producto no encontrado en Neo4j: productId={}", (Object)productId);
            return null;
        }
        catch (Exception e) {
            log.error("Error de conexi\u00f3n a Neo4j al obtener producto {}: {}", (Object)productId, (Object)e.getMessage());
            return null;
        }
    }
}

