/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.infrastructure.async;

import ec.tws2.back.lhia.marcimex.infrastructure.service.repositories.ConversationRepository;
import ec.tws2.back.lhia.marcimex.models.entity.Conversacion;
import java.time.LocalDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class LhiaConversationAsync {
    private static final Logger log = LoggerFactory.getLogger(LhiaConversationAsync.class);
    private final ConversationRepository conversationRepository;

    public LhiaConversationAsync(ConversationRepository conversationRepository) {
        this.conversationRepository = conversationRepository;
    }

    @Async(value="taskExecutor")
    public void saveMarkConversationAgent(String messageLhia, String idPlatform) {
        try {
            if (!"REDIRECT_ASESOR".equals(messageLhia)) {
                log.debug("saveConversationAgent ignored: event={}, idPlatform={}", (Object)messageLhia, (Object)idPlatform);
                return;
            }
            Optional conversationOpt = this.conversationRepository.getConversationByIdentificationLast(idPlatform);
            if (conversationOpt.isEmpty()) {
                log.warn("saveConversationAgent: conversation not found. idPlatform={}", (Object)idPlatform);
                return;
            }
            Conversacion conversation = (Conversacion)conversationOpt.get();
            conversation.setAsignadoAgente(Boolean.valueOf(true));
            conversation.setFechaAsignacionAgente(LocalDateTime.now());
            this.conversationRepository.save(conversation);
            log.info("saveConversationAgent: assigned agent successfully. idPlatform={} uuid={}", (Object)idPlatform, (Object)conversation.getIdentificador());
        }
        catch (Exception e) {
            log.error("saveConversationAgent failed. idPlatform={}", (Object)idPlatform, (Object)e);
            throw e;
        }
    }
}

