/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.common.util;

import ec.tws2.back.lhia.marcimex.models.data.ConversacionUsuario;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorial;
import ec.tws2.back.lhia.marcimex.models.data.ResponseRobot;
import ec.tws2.back.lhia.marcimex.models.data.RespuestaVector;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;

public class UtilLhia {
    private Logger log = Logger.getLogger(UtilLhia.class.getName());

    public void mostrarLista(List<ConversacionUsuario> lstConversation) {
        this.log.info("------------------------------------------------------------------------");
        for (int i = 0; i < lstConversation.size(); ++i) {
            this.log.info("rol:" + lstConversation.get(i).getRole());
            this.log.info("mensaje:" + lstConversation.get(i).getContent());
            this.log.info("------------------------------------------------------------------------");
        }
        this.log.info("------------------------------------------------------------------------");
    }

    public String obtenerUltimaRespuesta(List<ConversacionUsuario> lstConversation) {
        String resp = "";
        for (int i = lstConversation.size() - 1; i > 0; --i) {
            if (!lstConversation.get(i).getRole().equals("assistant")) continue;
            resp = lstConversation.get(i).getContent();
            break;
        }
        return resp;
    }

    public String parseEmbedding(String response) {
        JSONObject jsonObject = new JSONObject(response);
        JSONArray jsonArray = jsonObject.getJSONArray("embedding");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringBuilder.append(jsonArray.getDouble(i));
            if (i == jsonArray.length() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public double cosineSimilarity(String embedding1, String embedding2) {
        double[] arr1 = Stream.of(embedding1.split(",")).mapToDouble(Double::parseDouble).toArray();
        double[] arr2 = Stream.of(embedding2.split(",")).mapToDouble(Double::parseDouble).toArray();
        double dotProduct = 0.0;
        double norm1 = 0.0;
        double norm2 = 0.0;
        for (int i = 0; i < arr1.length; ++i) {
            dotProduct += arr1[i] * arr2[i];
            norm1 += Math.pow(arr1[i], 2.0);
            norm2 += Math.pow(arr2[i], 2.0);
        }
        if (norm1 == 0.0 || norm2 == 0.0) {
            return 0.0;
        }
        return dotProduct / (Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    public Date fechaEcuador() {
        LocalDateTime fechaHoraEcuador = LocalDateTime.now();
        return Date.from(fechaHoraEcuador.atZone(ZoneId.systemDefault()).toInstant());
    }

    public String quitarTildes(String texto) {
        String textoNormalizado = Normalizer.normalize(texto, Normalizer.Form.NFD);
        String textoSinTildes = textoNormalizado.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        String fraseFinal = textoSinTildes.replaceAll("\\?+", "?");
        return fraseFinal;
    }

    public String removeAsterisksAndHyphens(String input) {
        return input.replace("*", "").replace("-", "");
    }

    public ResponseRobot getResponseRobotOfListProduct(String question, List<ProductVectorial> secciones) {
        StringBuilder resultadoBusqueda = new StringBuilder();
        resultadoBusqueda.append("Disponemos de: \n");
        for (ProductVectorial seccion : secciones) {
            resultadoBusqueda.append(seccion.getTitulo()).append("\n").append("Precio: " + seccion.getPrecio() + "\n\n");
        }
        ResponseRobot responseR = new ResponseRobot();
        if (resultadoBusqueda.toString().isEmpty()) {
            responseR.setResponse("No disponemos de ese producto por el momento, pero puedes consultar sobre otro que te interese.");
            responseR.setListProductVectorial(new ArrayList());
        } else {
            responseR.setResponse(resultadoBusqueda.toString());
            responseR.setListProductVectorial(secciones);
        }
        return responseR;
    }

    public ResponseRobot createDefaultResponse(String text) {
        ResponseRobot responseR = new ResponseRobot();
        responseR.setResponse(text);
        responseR.setListProductVectorial(new ArrayList());
        return responseR;
    }

    public boolean containsAny(String text, String ... keywords) {
        return Arrays.stream(keywords).anyMatch(keyword -> text.toLowerCase().contains(keyword.toLowerCase()));
    }

    public String extractTextFromResponse(ResponseEntity<Map<String, Object>> response) {
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        return (String)messageObj.get("content");
    }

    public String preparePromptPrincipal(String question) {
        return question.isEmpty() ? "usuario: hola" : question.toUpperCase().replaceAll("\n", "");
    }

    public String buildPromptCompleto(ResponseEntity<RespuestaVector> responseResponseVector, String promptPrincipal) {
        String contentVectorial = ((RespuestaVector)responseResponseVector.getBody()).getContenido();
        Object prompt = contentVectorial.isEmpty() ? "contexto: no se encontro la informacion\n" : "contexto: el resultado de Asistente es el siguiente:\n" + contentVectorial + "\n";
        return ((String)prompt).concat("pregunta: " + promptPrincipal);
    }
}

