/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.common.util;

import ec.tws2.back.lhia.marcimex.models.entity.Purchase;
import ec.tws2.back.lhia.marcimex.models.enums.PurchaseType;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Exception performing whole class analysis ignored.
 */
public class PurchaseUtils {
    public static final String LABEL_CREDIT = "Cr\u00e9dito directo";
    public static final String LABEL_CASH = "Pagar efectivo \u00f3 tarjeta";
    public static final String MESSAGE_ASESOR = "asesor";
    public static final String MESSAGE_PROMOTION = "PROMOCION";
    public static final String MESSAGE_PROMOTION_SEARCH = "Producto Categoria: PROMOCION";
    public static final String MESSAGE_TAP_ONE_OF_THE_OPTIONS = "*Toque una de las opciones:*";
    public static final String MESSAGE_FINISH_BOT = "Gracias por confiar en *Marcimex*, fue un placer atenderte.\n\nMarcimex piensa en ti.";
    public static final String MESSAGE_PAY_WITH_BANK_CARD = "Pagar con Tarjeta Bancaria";
    public static final String MESSAGE_PAY_WITH_TRANSFER_OR_DEPOSIT = "Pagar con Transferencia o dep\u00f3sito";
    public static final String MESSAGE_JUST_ASKING = "Solo consultaba";
    public static final String MESSAGE_PRODUCT_ADD = "\u2705 \u00a1Producto agregado a tu carrito!";
    public static final String MESSAGE_SELECT_PAYMENT = "Como deseas Pagar:";
    public static final String MESSAGE_TOUCH_FINALLY_CHAT = "\u2b07\ufe0f *Toque aqu\u00ed para finalizar el chat*";
    public static final String EVENT_ADD_PRODUCT = "ADD_PRODUCT";
    public static final String EVENT_ADD_CART = "ADD_CART";
    public static final String EVENT_DETAIL = "DETAIL";
    public static final String EVENT_FINISH = "FINALIZAR";
    public static final String EVENT_PURCHASE = "COMPRAR";
    public static final String EVENT_PURCHASE_CREDIT = "COMPRAR_CREDIT";
    public static final String EVENT_PURCHASE_CASH = "COMPRAR_CASH";
    public static final String EVENT_VIEW_CART = "VER_CARRITO";
    public static final String EVENT_REDIRECT_ASESOR = "REDIRECT_ASESOR";

    public static PurchaseType mapPaymentMethod(String method) {
        return switch (method) {
            case "Cr\u00e9dito directo" -> PurchaseType.CREDIT;
            case "Pagar efectivo \u00f3 tarjeta" -> PurchaseType.CASH;
            default -> PurchaseType.ALL;
        };
    }

    public static String getMessagePurchase(String methodPayment, String linkCart) {
        switch (methodPayment) {
            case "Pagar con Tarjeta Bancaria": {
                return PurchaseUtils.getMessagePurchase1((String)linkCart);
            }
            case "Pagar con Transferencia o dep\u00f3sito": {
                return PurchaseUtils.getMessagePurchase2((String)linkCart);
            }
            case "Solo consultaba": {
                return PurchaseUtils.getMessagePurchase3((String)linkCart);
            }
        }
        return PurchaseUtils.getMessagePurchase3((String)linkCart);
    }

    public static final String getMessagePurchase1(String linkCart) {
        return "Continuaremos en el sitio web de marcimex.com. Para ello he creado un carrito de compras para que puedas ingresar tus datos de manera segura y posterior tu tarjeta para realizar el pago. Ir al Link:\n\n" + linkCart + " , Aceptamos todas las tarjetas de cr\u00e9dito y d\u00e9bito. Puedes diferir tu compra hasta 12 meses sin intereses.";
    }

    public static final String getMessagePurchase2(String linkCart) {
        return "Continuaremos en el sitio web de marcimex.com. Para ello he creado un carrito de compras para que puedas ingresar tus datos de manera segura, Ir al Link:\n\n" + linkCart + " , No te olvides, al realizar el proceso de compra, seleccionar *TRANSFERENCIA BANCARIA* para que un asesor se comunique contigo y atendamos tu pedido.";
    }

    public static final String getMessagePurchase3(String linkCart) {
        return "Listo, te compartimos el link de tu carrito de compras.\n\nIr al Link: " + linkCart;
    }

    public static String getEventName(String activity) {
        if (activity == null) {
            return "";
        }
        if (activity.contains("ADD_CART_")) {
            return "ADD_CART";
        }
        if (activity.contains("DETAIL_")) {
            return "DETAIL";
        }
        return activity;
    }

    public static String getProductIdFromEvent(String activity, String event) {
        if ("ADD_CART".equals(event) || "DETAIL".equals(event)) {
            int idx = activity.lastIndexOf("_");
            return idx != -1 && idx < activity.length() - 1 ? activity.substring(idx + 1) : "";
        }
        return "";
    }

    public static String getDetailCart(Optional<Purchase> purchaseFind) {
        StringBuilder detailCartBuilder = new StringBuilder();
        AtomicInteger index = new AtomicInteger(0);
        purchaseFind.get().getPurchaseDetails().forEach(product -> {
            String itemEmoji = PurchaseUtils.getEmojiNumber((int)index.incrementAndGet());
            String detailCart = String.format("%s %s\n\ud83d\udce6 *Cant*: %d\n\ud83d\udcb5 *P. Unit*: $%.2f\n\n", itemEmoji, product.getDescription(), product.getQuantity(), product.getUnitPrice());
            detailCartBuilder.append(detailCart);
        });
        String dataView = String.format("\ud83d\uded2 *Carrito de compras:*\n\n%s\ud83d\udcb0 *Total*: $%.2f", detailCartBuilder, purchaseFind.get().getTotalAmount());
        return dataView;
    }

    public static String getEmojiNumber(int num) {
        String textEmoji = String.valueOf(num);
        StringBuilder result = new StringBuilder();
        for (char c : textEmoji.toCharArray()) {
            result.append(c).append("\ufe0f\u20e3");
        }
        return result.toString();
    }
}

