/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorial;
import ec.tws2.back.lhia.marcimex.models.data.ProductVectorialTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ProductVectorMapper {
    private static final Logger log = LoggerFactory.getLogger(ProductVectorMapper.class);

    public static List<ProductVectorial> mapToListProductVectorial(String contentVectorial) {
        String[] registers;
        ArrayList<ProductVectorial> listProducts = new ArrayList<ProductVectorial>();
        for (String register : registers = contentVectorial.split("\n\n")) {
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            String[] fields = register.split(", (?=[a-zA-Z ]+:)");
            StringBuilder combinedField = new StringBuilder();
            String previousKey = null;
            for (String field : fields) {
                String[] keyValue = field.split(":", 2);
                if (keyValue.length == 2) {
                    String key = keyValue[0].trim().toLowerCase();
                    String value = keyValue[1].trim();
                    if (previousKey != null) {
                        fieldMap.put(previousKey, combinedField.toString().trim());
                        combinedField.setLength(0);
                    }
                    previousKey = key;
                    combinedField.append(value);
                    continue;
                }
                if (previousKey == null) continue;
                combinedField.append(", ").append(field);
            }
            if (previousKey != null) {
                fieldMap.put(previousKey, combinedField.toString().trim());
            }
            ProductVectorial product = new ProductVectorial();
            product.setId(ProductVectorMapper.parseLongOrDefault((String)((String)fieldMap.get("_id")), (Long)0L));
            product.setDescripcion(fieldMap.getOrDefault("descripcion", ""));
            product.setTitulo(fieldMap.getOrDefault("titulo", ""));
            product.setResumen(fieldMap.getOrDefault("resumen", ""));
            product.setCategoria(fieldMap.getOrDefault("categoria", ""));
            product.setCategoriaGlobal(fieldMap.getOrDefault("categoria global", ""));
            product.setSubCategoria(fieldMap.getOrDefault("sub categoria", ""));
            product.setTipoProducto(fieldMap.getOrDefault("tipo producto", ""));
            product.setMarca(fieldMap.getOrDefault("marca", ""));
            product.setLink(fieldMap.getOrDefault("link", ""));
            product.setImagenUrl(fieldMap.getOrDefault("imagen url", ""));
            if (ProductVectorMapper.isValidProduct((ProductVectorial)product)) {
                listProducts.add(product);
                continue;
            }
            System.out.println("Product No valid");
            System.out.println(product.toString());
        }
        return listProducts;
    }

    private static boolean isValidProduct(ProductVectorial product) {
        return product.getId() != 0L && product.getDescripcion() != null && !product.getDescripcion().isEmpty() && product.getTitulo() != null && !product.getTitulo().isEmpty() && product.getImagenUrl() != null && !product.getImagenUrl().isEmpty() && product.getPrecio() != null && !product.getPrecio().isEmpty();
    }

    public static Long parseLongOrDefault(String value, Long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public List<ProductVectorial> transformarRespuestaALista(String texto) {
        try {
            String transformado = texto.replace("\"", "").replace("'", "\"");
            texto = this.escapeJsonString(texto);
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<ProductVectorialTransform> productos = new ArrayList<ProductVectorialTransform>();
            String[] parts = transformado.split("\n");
            for (String part : parts) {
                if ((part = part.replace("\n", "")).isEmpty()) continue;
                values.add(part);
            }
            for (String value : values) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    ProductVectorialTransform product = (ProductVectorialTransform)objectMapper.readValue(value, ProductVectorialTransform.class);
                    product.setProductCategory(product.getProductCategory() != null ? product.getProductCategory() : "");
                    productos.add(product);
                }
                catch (Exception e) {
                    log.error("Error al transformar el texto", (Throwable)e);
                }
            }
            return this.transformListToProductVectorial(productos);
        }
        catch (Exception e) {
            log.info("Error al transformar el texto" + String.valueOf(e));
            return new ArrayList<ProductVectorial>();
        }
    }

    public String escapeJsonString(String jsonString) {
        StringBuilder escapedJson = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < jsonString.length(); ++i) {
            char currentChar = jsonString.charAt(i);
            if (currentChar == '\"') {
                if (inQuotes) {
                    if (i + 1 < jsonString.length() && jsonString.charAt(i + 1) != ',' && jsonString.charAt(i + 1) != '}' && jsonString.charAt(i + 1) != ' ') {
                        escapedJson.append("\\\"");
                        continue;
                    }
                    escapedJson.append(currentChar);
                    inQuotes = false;
                    continue;
                }
                inQuotes = true;
                escapedJson.append(currentChar);
                continue;
            }
            escapedJson.append(currentChar);
        }
        return escapedJson.toString();
    }

    public List<ProductVectorial> transformListToProductVectorial(List<ProductVectorialTransform> list) {
        ArrayList<ProductVectorial> listProductVectorial = new ArrayList<ProductVectorial>();
        try {
            for (ProductVectorialTransform productVectorialTransform : list) {
                ProductVectorial productVectorial = new ProductVectorial();
                productVectorial.setId(productVectorialTransform.getId());
                productVectorial.setSkuId(productVectorialTransform.getSkuId());
                productVectorial.setDescripcion(productVectorialTransform.getDescripcion());
                productVectorial.setTitulo(productVectorialTransform.getTitulo());
                productVectorial.setResumen(productVectorialTransform.getResumen());
                productVectorial.setCategoria(productVectorialTransform.getCategoria());
                productVectorial.setCategoriaGlobal(productVectorialTransform.getCategoriaGlobal());
                productVectorial.setSubCategoria(productVectorialTransform.getSubCategoria());
                productVectorial.setTipoProducto(productVectorialTransform.getTipoProducto());
                productVectorial.setMarca(productVectorialTransform.getMarca());
                productVectorial.setLink(productVectorialTransform.getLink());
                productVectorial.setImagenUrl(productVectorialTransform.getImagenUrl());
                productVectorial.setPrecio(productVectorialTransform.getPrecio());
                productVectorial.setCantidad(productVectorialTransform.getCantidad());
                productVectorial.setProductCategory(productVectorialTransform.getProductCategory());
                listProductVectorial.add(productVectorial);
            }
            return listProductVectorial;
        }
        catch (Exception e) {
            log.info("ERROR al transforma lista vectorial [transformListToProductVectorial]" + String.valueOf(e));
            return listProductVectorial;
        }
    }
}

