/*
 * Decompiled with CFR 0.152.
 */
package ec.tws2.back.lhia.marcimex.common.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.UUID;
import javax.imageio.ImageIO;

public class ImagesUtils {
    public static String nameImage2() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String formattedDateTime = now.format(formatter);
        return "image_" + formattedDateTime;
    }

    public static String nameImage() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSSSSS_SSS");
        String formattedDateTime = now.format(formatter);
        String uniqueID = UUID.randomUUID().toString();
        return "image_" + formattedDateTime + "_" + uniqueID;
    }

    public String getUrlImage(String base64Image, String fileName, String pathTemp) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64Image);
            ByteArrayInputStream bis = new ByteArrayInputStream(decodedBytes);
            BufferedImage image = ImageIO.read(bis);
            String filePath = pathTemp + fileName + ".png";
            System.out.println(filePath);
            File file = new File(filePath);
            System.out.println(file);
            file.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)image, "png", file);
            System.out.println("Imagen guardada exitosamente en: " + filePath);
            return fileName + ".png";
        }
        catch (IOException e) {
            System.out.println("Error al guardar la imagen");
            return "";
        }
    }

    public boolean deleteImage(String fileName, String pathTemp) {
        String filePath = pathTemp + fileName;
        File file = new File(filePath);
        if (file.exists()) {
            if (file.delete()) {
                System.out.println("Imagen eliminada exitosamente: " + filePath);
                return true;
            }
            System.out.println("Error al eliminar la imagen: " + filePath);
            return false;
        }
        System.out.println("La imagen no existe: " + filePath);
        return false;
    }
}

