/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.web.service.impl;

import com.whatsapp.tws2.client.botpress.service.ApiBotpressService;
import com.whatsapp.tws2.client.lhiaflow.MarcimexCallbackResponse;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.utils.StatusUtil;
import com.whatsapp.tws2.web.models.BotpressWebHookModel;
import com.whatsapp.tws2.web.service.WebChannelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class WebChannelServiceImpl
implements WebChannelService {
    private static final Logger log = LoggerFactory.getLogger(WebChannelServiceImpl.class);
    private final ApiBotpressService apiBotpressService;
    private final StateConversationService stateConversationService;
    private final Environment env;

    public Mono<ResponseEntity<?>> sendMessageToBotpressWeb(MarcimexCallbackResponse callbackResponse) {
        String defaultCallback = this.env.getProperty("lhiaflow.callback.atencion");
        BotpressWebHookModel request = new BotpressWebHookModel();
        request.setConversationId(callbackResponse.getConversationId());
        request.setRoomId(callbackResponse.getRoomId());
        switch (callbackResponse.getType()) {
            case "text": {
                request.setType("text");
                String message = callbackResponse.getPayload().getText() == null ? "" : callbackResponse.getPayload().getText();
                request.getPayload().setText(callbackResponse.getPayload().getText());
                if (message.toUpperCase().contains("EL CHAT FUE CERRADO")) {
                    return this.stateConversationService.validateAndUpdateChat(request.getConversationId(), StatusUtil.ST_NORMAL, defaultCallback).then(this.apiBotpressService.notifyWebHookWEB((Object)request).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)response))));
                }
            }
            case "document": {
                request.setType("file");
                request.getPayload().setUrl(callbackResponse.getPayload().getUrl());
            }
        }
        request.setType(callbackResponse.getType());
        request.getPayload().setUrl(callbackResponse.getPayload().getUrl());
        return this.stateConversationService.validateStateAsesor(request.getConversationId()).then(this.apiBotpressService.notifyWebHookWEB((Object)request).flatMap(response -> {
            log.info("response botpress {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)response));
        }));
    }

    public WebChannelServiceImpl(ApiBotpressService apiBotpressService, StateConversationService stateConversationService, Environment env) {
        this.apiBotpressService = apiBotpressService;
        this.stateConversationService = stateConversationService;
        this.env = env;
    }
}

