/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.client.botpress.service.ApiBotpressService;
import com.whatsapp.tws2.client.fileStorage.FileService;
import com.whatsapp.tws2.client.lhia.service.ApiLhiaService;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.events.UserResponse;
import com.whatsapp.tws2.service.AsesorHiperService;
import com.whatsapp.tws2.service.CampaignService;
import com.whatsapp.tws2.service.LhiaProcessService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.service.WebhookService;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.ResponseUtil;
import com.whatsapp.tws2.utils.StatusUtil;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class WebhookServiceImpl
implements WebhookService {
    private static final Logger log = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private final StateConversationService stateConversationService;
    private final Environment env;
    private final ApiBotpressService apiBotpressService;
    private final ObjectMapper objectMapper;
    private final ResponseUtil responseUtil;
    private final LhiaProcessService lhiaProcessService;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ApiWhatsAppService whatsAppService;
    private final ApiLhiaService apiLhiaService;
    private final ThinkAgentService thinkAgentService;
    private final AsesorHiperService asesorHiperService;
    private final CampaignService campaignService;
    private final FileService fileService;

    public Mono<ResponseEntity<?>> handleWebhook(Object userResponse) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        Mono convertedRequestBody = this.convertToUserResponse(userResponse);
        return convertedRequestBody.flatMap(metaEvent -> {
            log.info("continua el flujo del evento recibido");
            return this.convertToUserResponse(userResponse).flatMap(userBody -> this.stateConversationService.validateAndUpdateChatFromUserResponse(userBody).flatMap(status -> {
                log.info("status conversation> " + status);
                switch (status) {
                    case "ASESOR": {
                        return this.responseUtil.getMessage(userBody).flatMap(usrBody -> this.continuarFlujoAsesor(usrBody, defaultCallback, StatusUtil.ST_ASESOR));
                    }
                    case "CAMPANA": {
                        return this.responseUtil.getMessage(userBody).flatMap(data -> this.stateConversationService.getCallbackIdFromConversationId(data.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
                            if (callbackId.startsWith(this.env.getProperty("tsa.canal.prefix"))) {
                                return this.handleCampaignCase(data);
                            }
                            return this.responseUtil.getMessage(userBody).flatMap(usrBody -> this.continuarFlujoAsesor(usrBody, callbackId, StatusUtil.ST_CAMPANA));
                        }));
                    }
                    case "NORMAL": 
                    case "LHIA": {
                        return this.responseUtil.getMessage(userBody).flatMap(body -> {
                            log.info("WEBHOOK DATA TO LHIA {}", body);
                            if (body.getType().equals(MessageTypeUtils.TYPE_TEXT) || body.getType().equals(MessageTypeUtils.TYPE_INTERACTIVE) || body.getType().equals(MessageTypeUtils.TYPE_BUTTON)) {
                                log.info("IS A TEXT OR INTERACTIVE MESSAGE TO LHIA");
                                return this.lhiaProcessService.sendMessageLhiaSwitch(body).map(res -> ResponseEntity.ok().build());
                            }
                            if (body.getType().equals(MessageTypeUtils.TYPE_AUDIO)) {
                                log.info("IS AN AUDIO MESSAGE TO LHIA, downloading audio file...");
                                this.whatsAppService.downloadFileFromUrl(body.getFile()).flatMap(audioBytes -> {
                                    log.info("Audio downloaded, size: {} bytes. Sending to transcription API...", (Object)((byte[])audioBytes).length);
                                    return this.apiLhiaService.transcribeAudio(audioBytes);
                                }).flatMap(transcriptionJson -> {
                                    log.info("TRANSCRIPTION RESULT: {}", transcriptionJson);
                                    try {
                                        JsonNode jsonNode = this.objectMapper.readTree(transcriptionJson);
                                        String transcripcion = jsonNode.path("transcripcion").asText("");
                                        if (transcripcion.isEmpty()) {
                                            log.warn("Transcription is empty, continuing to thinkAgent flow");
                                            return Mono.error((Throwable)new RuntimeException("Empty transcription"));
                                        }
                                        body.setMessage(transcripcion);
                                        body.setType(MessageTypeUtils.TYPE_TEXT);
                                        return this.lhiaProcessService.sendMessageLhiaSwitch(body);
                                    }
                                    catch (Exception e) {
                                        log.error("Error parsing transcription JSON: {}", (Object)e.getMessage());
                                        return Mono.error((Throwable)e);
                                    }
                                }).onErrorResume(e -> {
                                    log.error("Audio transcription failed, falling back to thinkAgent: {}", (Object)e.getMessage());
                                    return this.thinkAgentService.sendMessageToTAS(body, null).flatMap(res -> {
                                        log.info("THINKAGENT RESPONSE {}", res);
                                        TextMessageRequest textMessagaReq = new TextMessageRequest(body.getIdConversation(), StatusUtil.MSG_NOTIFICACION_CLIENTE_ARCHIVOS_ASESOR);
                                        return this.whatsAppService.sendTextMessage(textMessagaReq).then();
                                    });
                                }).subscribe();
                                return Mono.just((Object)ResponseEntity.ok().build());
                            }
                            if (body.getType().equals(MessageTypeUtils.TYPE_IMAGE)) {
                                log.info("IS AN IMAGE MESSAGE TO LHIA, describing image...");
                                this.apiLhiaService.getToken().flatMap(tokenModel -> this.apiLhiaService.describeImage(body.getFile(), tokenModel.getAccessToken())).flatMap(describeJson -> {
                                    try {
                                        JsonNode jsonNode = this.objectMapper.readTree(describeJson);
                                        String description = jsonNode.path("payload").asText("");
                                        if (description.isEmpty()) {
                                            return Mono.error((Throwable)new RuntimeException("Empty image description"));
                                        }
                                        String caption = body.getMessage();
                                        String message = this.getMessageCaption(description, caption);
                                        body.setMessage(message);
                                        body.setType(MessageTypeUtils.TYPE_TEXT);
                                        return this.lhiaProcessService.sendMessageLhiaSwitch(body).onErrorResume(lhiaError -> {
                                            log.error("LHIA processing failed after image description: {}", (Object)lhiaError.getMessage());
                                            return Mono.empty();
                                        });
                                    }
                                    catch (Exception e) {
                                        log.error("Error parsing image description JSON: {}", (Object)e.getMessage());
                                        return Mono.error((Throwable)e);
                                    }
                                }).onErrorResume(e -> {
                                    log.error("Image description failed, falling back to thinkAgent: {}", (Object)e.getMessage());
                                    return this.thinkAgentService.sendMessageToTAS(body, null).flatMap(res -> {
                                        TextMessageRequest textMessagaReq = new TextMessageRequest(body.getIdConversation(), StatusUtil.MSG_NOTIFICACION_CLIENTE_ARCHIVOS_ASESOR);
                                        return this.whatsAppService.sendTextMessage(textMessagaReq).then();
                                    });
                                }).subscribe();
                                return Mono.just((Object)ResponseEntity.ok().build());
                            }
                            return this.thinkAgentService.sendMessageToTAS(body, null).flatMap(res -> {
                                log.info("THINKAGENT RESPONSE {}", res);
                                TextMessageRequest textMessagaReq = new TextMessageRequest(body.getIdConversation(), StatusUtil.MSG_NOTIFICACION_CLIENTE_ARCHIVOS_ASESOR);
                                return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(metaRes -> {
                                    log.info("Mensaje enviado a WhatsApp: {}", metaRes);
                                    return Mono.just((Object)ResponseEntity.ok().build());
                                });
                            });
                        });
                    }
                    case "THINKAGENT": {
                        return this.responseUtil.getMessage(userBody).flatMap(body -> this.thinkAgentService.sendMessageToTAS(body, null).flatMap(res -> {
                            log.info("THINKAGENT RESPONSE {}", res);
                            return Mono.just((Object)ResponseEntity.ok().build());
                        }));
                    }
                }
                return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
            })).onErrorResume(e -> {
                log.error("Error handling webhook: ", e);
                return Mono.just((Object)ResponseEntity.status((int)500).body((Object)"Internal Server Error"));
            });
        });
    }

    private String getMessageCaption(String description, String caption) {
        return caption != null && !caption.isEmpty() ? caption + " " + description : description;
    }

    private Mono<UserResponse> convertToUserResponse(Object userResponse) {
        log.info("Converting user response: {}", userResponse);
        try {
            String json = this.objectMapper.writeValueAsString(userResponse);
            System.err.println("json: 1" + json);
            UserResponse userBody = (UserResponse)this.objectMapper.readValue(json, UserResponse.class);
            return Mono.just((Object)userBody);
        }
        catch (Exception e) {
            log.error("Error converting user response: ", (Throwable)e);
            return Mono.error((Throwable)new RuntimeException("Invalid user response format"));
        }
    }

    private Mono<ResponseEntity<?>> handleThinkAgentCase(ExtractData data) {
        return this.stateConversationService.getCallbackIdFromConversationId(data.getIdConversation()).defaultIfEmpty((Object)"").flatMap(canal -> this.campaignService.getLatestAgentUserName(data.getIdConversation(), canal).defaultIfEmpty((Object)"").flatMap(agentUsername -> {
            log.info("Enviando respuesta de campa\u00f1a a TSA - idConversation: {}, Canal: {}, Agente-Username: {}", new Object[]{data.getIdConversation(), canal, agentUsername});
            return this.thinkAgentService.sendMessageToTAS(data, agentUsername).map(res -> ResponseEntity.ok().build());
        }));
    }

    private Mono<ResponseEntity<?>> handleCampaignCase(ExtractData data) {
        log.info("CAMPA\u00d1A, data {}", (Object)data);
        return this.campaignMessageDAO.findLastMessageTemplateByConversationId(data.getIdConversation()).flatMap(campaignMessage -> {
            if (!campaignMessage.isBlank()) {
                String messageOriginal;
                Object newMessageModified = "";
                String string = messageOriginal = data.getMessage() == null ? "" : data.getMessage();
                if (!data.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                    ExtractData textMessageModel = new ExtractData(data);
                    newMessageModified = "*Msg usuario:* [Archivo adjunto en el siguiente mensaje]\n*Campa\u00f1a:* " + campaignMessage;
                    textMessageModel.setMessage((String)newMessageModified);
                    textMessageModel.setType(MessageTypeUtils.TYPE_TEXT);
                    log.warn("EL MENSAJE DE CAMPANA CON ARCHIVOS ES: {}", (Object)data.getMessage());
                    return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(textMessageModel).delayElement(Duration.ofSeconds(3L)).flatMap(res -> this.handleThinkAgentCase(data)));
                }
                newMessageModified = "*Msg usuario:* " + messageOriginal + "\n*Campa\u00f1a:* " + campaignMessage;
                data.setMessage((String)newMessageModified);
                log.warn("EL MENSAJE DE CAMPANA ES: {}", (Object)data.getMessage());
            }
            return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(data));
        });
    }

    private Mono<ResponseEntity<?>> continuarFlujoAsesor(ExtractData usrBody, String callbackId, String estado) {
        String fileUrl = usrBody.getFile();
        Mono updatedBodyMono = fileUrl == null || fileUrl.isEmpty() ? Mono.just((Object)usrBody) : Mono.defer(() -> this.fileService.getUrlFileStorage(fileUrl).map(newUrl -> {
            if (newUrl != null && !newUrl.isEmpty()) {
                usrBody.setMessage(newUrl);
            } else {
                usrBody.setMessage(fileUrl);
            }
            return usrBody;
        }));
        return updatedBodyMono.flatMap(updatedBody -> this.asesorHiperService.flujoAsesor(updatedBody, callbackId, estado));
    }

    public WebhookServiceImpl(StateConversationService stateConversationService, Environment env, ApiBotpressService apiBotpressService, ObjectMapper objectMapper, ResponseUtil responseUtil, LhiaProcessService lhiaProcessService, CampaignMessageDAO campaignMessageDAO, ApiWhatsAppService whatsAppService, ApiLhiaService apiLhiaService, ThinkAgentService thinkAgentService, AsesorHiperService asesorHiperService, CampaignService campaignService, FileService fileService) {
        this.stateConversationService = stateConversationService;
        this.env = env;
        this.apiBotpressService = apiBotpressService;
        this.objectMapper = objectMapper;
        this.responseUtil = responseUtil;
        this.lhiaProcessService = lhiaProcessService;
        this.campaignMessageDAO = campaignMessageDAO;
        this.whatsAppService = whatsAppService;
        this.apiLhiaService = apiLhiaService;
        this.thinkAgentService = thinkAgentService;
        this.asesorHiperService = asesorHiperService;
        this.campaignService = campaignService;
        this.fileService = fileService;
    }
}

