/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.HistoryConversationItemReactive;
import com.whatsapp.tws2.Repository.Services.ConversationDAO;
import com.whatsapp.tws2.client.lhiaflow.LhiaFlowRequest;
import com.whatsapp.tws2.client.lhiaflow.MarcimexCallbackResponse;
import com.whatsapp.tws2.client.lhiaflow.service.ApiLhiaFLowService;
import com.whatsapp.tws2.client.tsa.TsaApiService;
import com.whatsapp.tws2.client.tsa.models.Attachment;
import com.whatsapp.tws2.client.tsa.models.CallbackTsaMessage;
import com.whatsapp.tws2.client.tsa.models.ResponseMessageEvent;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.FileMessageRequestFromHiper;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.tsa.RequestMessageModel;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.HistoryConversationService;
import com.whatsapp.tws2.service.RedirectConversationService;
import com.whatsapp.tws2.service.StartConversationEvents;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.tsa.utils.TemplateTsaMessages;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.StatusUtil;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ThinkAgentServiceImpl
implements ThinkAgentService {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentServiceImpl.class);
    private final TsaApiService tsaApiService;
    private final StateConversationService stateConversationService;
    private final ApiWhatsAppService whatsAppService;
    private final HistoryConversationItemService historyConversationItemService;
    private final HistoryConversationService historyConversationService;
    private final RedirectConversationService redirectConversationsService;
    private final ApiLhiaFLowService apiLhiaFLowService;
    private final ConversationDAO conversationDAO;
    private final HistoryConversationItemReactive historyConversationItemReactive;
    private final StartConversationEvents startConversationEvents;
    private final Environment env;

    public Mono<ResponseEntity<String>> sendMessageToWhatsappFromTSA(RequestMessageModel requestMessageModel) {
        boolean isRedirectEvent;
        HistoryConversationItem historyConversationItem = HistoryConversationItem.saveConversationFromTsa((String)requestMessageModel.getId(), (String)requestMessageModel.getPayload().getContent(), (String)requestMessageModel.getNick(), (String)requestMessageModel.getPayload().getType(), (String)requestMessageModel.getAgentUsername());
        String messageType = requestMessageModel.getPayload().getType();
        if (messageType != null && messageType.equalsIgnoreCase(MessageTypeUtils.TYPE_TEXT) && (isRedirectEvent = this.redirectConversationsService.isEventRedirect(requestMessageModel.getPayload().getContent()))) {
            return this.validateAndRedirectConversationToHiper(requestMessageModel);
        }
        return this.processMessageToTsa(requestMessageModel).flatMap(response -> {
            log.info("response webhook {}", response);
            historyConversationItem.setMessageMetaId((String)response.getBody());
            return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent")).then(this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), StatusUtil.ST_THINKAGENT)).then(this.historyConversationItemService.save(historyConversationItem)).thenReturn(response);
        });
    }

    private Mono<ResponseEntity<String>> processMessageToTsa(RequestMessageModel requestMessageModel) {
        switch (requestMessageModel.getPayload().getType()) {
            case "text": {
                TextMessageRequest textMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
                if (textMessage.getMessage().toUpperCase().contains("POR FAVOR CALIFICA ESTA CONVERSACI")) {
                    return this.stateConversationService.getStatusCoonversation(requestMessageModel.getId()).flatMap(state -> {
                        log.info("Estado de la conversacion a cerrar: {}", state);
                        if (state.equalsIgnoreCase(StatusUtil.ST_ASESOR)) {
                            log.info("MENSAJE IGNORADO POR CAMBIO DE ASESOR");
                            return Mono.empty();
                        }
                        return this.whatsAppService.sendTextMessage(textMessage).flatMap(messageMetaId -> {
                            log.info("Meta message id: {}", messageMetaId);
                            return this.stateConversationService.updateStateByConversationId(textMessage.getPhoneNumber(), StatusUtil.ST_NORMAL).map(response -> messageMetaId);
                        });
                    });
                }
                if (textMessage.getMessage().toUpperCase().contains("ESTE MENSAJE SE HA ELIMINADO")) {
                    log.info("Mensaje de eliminaci\u00f3n ignorado");
                    return Mono.just((Object)ResponseEntity.ok((Object)UUID.randomUUID().toString()));
                }
                return this.whatsAppService.sendTextMessage(textMessage);
            }
            case "image": {
                FileMessageRequestFromHiper imageFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendImageMessage(imageFileRequest);
            }
            case "video": {
                FileMessageRequestFromHiper videoFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendVideoMessage(videoFileRequest);
            }
            case "document": {
                FileMessageRequestFromHiper documentFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendDocumentMessage(documentFileRequest);
            }
            case "audio": {
                FileMessageRequestFromHiper audioFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendAudioMessage(audioFileRequest);
            }
        }
        TextMessageRequest unknowTextMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
        return this.whatsAppService.sendTextMessage(unknowTextMessage);
    }

    private Mono<ResponseEntity<String>> validateAndRedirectConversationToHiper(RequestMessageModel requestMessageModel) {
        String callbackId = this.redirectConversationsService.getChannelFromChangeEvent(requestMessageModel.getPayload().getContent());
        log.info("Redirecting conversation from TSA to Hiper {}", (Object)callbackId);
        String event = requestMessageModel.getPayload().getContent();
        return this.historyConversationItemReactive.getConversationHistoryEstructure(event, requestMessageModel.getId()).flatMap(messagesHistory -> {
            LhiaFlowRequest model = new LhiaFlowRequest(requestMessageModel.getId(), requestMessageModel.getNick(), callbackId, MessageTypeUtils.TYPE_TEXT, messagesHistory);
            return this.apiLhiaFLowService.sendMesssageToAsesor(model).defaultIfEmpty((Object)"MENSAJE ENTREGADO A HIPER").flatMap(response -> {
                log.info("response webhook {}", response);
                this.stateConversationService.validateAndUpdateChat(model.getConversationChatId(), StatusUtil.ST_ASESOR, callbackId).subscribe();
                return this.tsaApiService.closeConvesation(model.getConversationChatId()).flatMap(responseApiTsa -> {
                    log.info("API TSA RESPONSE", responseApiTsa);
                    return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to Hiper"));
                });
            });
        });
    }

    public Mono<ResponseEntity<String>> sendMessageToTAS(ExtractData dataMessageMeta, @Nullable String agentUsername) {
        log.info("Data message meta: {}", (Object)dataMessageMeta);
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        RequestMessageModel requestMessageModel = new RequestMessageModel();
        RequestMessageModel.Payload payload = new RequestMessageModel.Payload();
        if (dataMessageMeta.getType().equalsIgnoreCase(MessageTypeUtils.TYPE_LOCATION)) {
            payload.setType(MessageTypeUtils.TYPE_TEXT);
            payload.setContent(TemplateTsaMessages.TEMPLATE_MD_LOCATION.replace("{lat}", dataMessageMeta.getLatitude()).replace("{lon}", dataMessageMeta.getLongitude()));
        } else if (dataMessageMeta.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
            payload.setType(dataMessageMeta.getType());
            payload.setContent(dataMessageMeta.getMessage());
        } else {
            if (dataMessageMeta.getFile() == null) {
                log.warn("TIPO DE DATO NO IDENTIFICADO O SOPORTADO, PROCEDE A IGNORAR");
                return Mono.just((Object)ResponseEntity.ok((Object)"mensaje aceptado"));
            }
            payload.setType(MessageTypeUtils.TYPE_FILE);
            payload.setContent(dataMessageMeta.getFile());
        }
        requestMessageModel.setType("message");
        requestMessageModel.setId(dataMessageMeta.getIdConversation());
        requestMessageModel.setPayload(payload);
        requestMessageModel.setChannel("whatsapp");
        requestMessageModel.setNick(dataMessageMeta.getNick());
        requestMessageModel.setAgentUsername(agentUsername);
        if (dataMessageMeta.getReplyMessageId() != null) {
            return this.historyConversationItemService.getMessageByMetaId(dataMessageMeta.getReplyMessageId()).flatMap(message -> {
                log.info("The message replied is: {}", message);
                requestMessageModel.getPayload().setRepliedMessage(message);
                return this.conversationDAO.getCallbackByConversationId(dataMessageMeta.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> this.saveSentMessageToTASFromWebhook(dataMessageMeta, (ResponseMessageEvent)response.getBody()).thenReturn((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"))));
            });
        }
        return this.conversationDAO.getCallbackByConversationId(dataMessageMeta.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> this.saveSentMessageToTASFromWebhook(dataMessageMeta, (ResponseMessageEvent)response.getBody()).thenReturn((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"))));
    }

    private Mono<Void> saveSentMessageToTASFromWebhook(ExtractData dataMessage, ResponseMessageEvent responseTsaEvent) {
        Boolean isOpenConversation = false;
        if (responseTsaEvent != null && responseTsaEvent.getEventType() != null) {
            String eventType = responseTsaEvent.getEventType();
            if (eventType.equalsIgnoreCase("new_conversation_opened")) {
                isOpenConversation = true;
            }
            if (eventType.equalsIgnoreCase("message_new_delivered") && !dataMessage.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                List attachments;
                CallbackTsaMessage objectCast = responseTsaEvent.getCallbackTsaMessage();
                log.error("EL OBJETO ES DE TIPO {}", (Object)objectCast);
                if (objectCast != null && (attachments = objectCast.getAttachments()) != null && !attachments.isEmpty()) {
                    Attachment attachment = (Attachment)attachments.get(0);
                    return this.saveSentMessageToTAS(dataMessage.getIdConversation(), dataMessage.getCanal(), attachment.getDataUrl(), dataMessage.getMessageId(), dataMessage.getNick(), attachment.getFileType(), isOpenConversation);
                }
            }
        }
        return this.saveSentMessageToTAS(dataMessage.getIdConversation(), dataMessage.getCanal(), dataMessage.getMessage(), dataMessage.getMessageId(), dataMessage.getNick(), MessageTypeUtils.TYPE_TEXT, isOpenConversation);
    }

    public Mono<Void> saveSentMessageToTAS(String idConversation, String canal, String content, String messageId, String nick, String messageType, Boolean isOpenConversation) {
        HistoryConversationItem historyConversationItem = HistoryConversationItem.saveNewMessageToTsa((String)idConversation, (String)content, (String)messageId, (String)nick, (String)messageType, (Boolean)isOpenConversation);
        log.info("data a: {}", (Object)historyConversationItem);
        return this.historyConversationItemService.save(historyConversationItem);
    }

    public Mono<ResponseEntity<String>> sendConversationToTSAFromHiper(MarcimexCallbackResponse marciCallback, String callbackId) {
        log.info("This conversation is redirecting to TSA with model: {} to team {}", (Object)marciCallback, (Object)callbackId);
        return this.historyConversationService.getNickByIdPlatform(marciCallback.getConversationId()).flatMap(nick -> {
            RequestMessageModel requestMessageModel = RequestMessageModel.createEventMigrationConversationToTSA((String)marciCallback.getConversationId(), (String)MessageTypeUtils.TYPE_MESSAGE, (String)nick, (String)marciCallback.getType(), (String)marciCallback.getPayload().getText());
            return this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> {
                log.info("response webhook hiper {}", response);
                return this.saveSentMessageToTAS(marciCallback.getConversationId(), "whatsapp", marciCallback.getPayload().getText(), UUID.randomUUID().toString(), nick, MessageTypeUtils.TYPE_TEXT, Boolean.valueOf(false)).thenReturn((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"));
            });
        });
    }

    private Mono<ResponseEntity<ResponseMessageEvent>> sendMessageToTAS(RequestMessageModel requestMessageModel, String callbackId) {
        return this.tsaApiService.sendMesssageToAsesor(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)response));
        });
    }

    public Mono<ResponseEntity<String>> redirectLhiaConversationToTSA(RequestMessageModel requestMessageModel) {
        String status = StatusUtil.ST_THINKAGENT;
        String callbackId = this.env.getProperty("tsa.canal.callback.ventas");
        requestMessageModel.setChannel("whatsapp");
        return this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), status).then(this.startConversationEvents.startConversation(requestMessageModel.getId(), requestMessageModel.getNick())).then(Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent")));
        });
    }

    public Mono<Void> redirectConversationToTSA(String event, MarcimexCallbackResponse marcimexCallbackResponse) {
        log.info("Redirecting conversation from Hiper to TSA");
        String callbackId = this.redirectConversationsService.getChannelFromChangeEvent(event);
        log.info("Redirecting conversation from Hiper to TSA with callbackId {}", (Object)callbackId);
        return this.sendConversationToTSAFromHiper(marcimexCallbackResponse, callbackId).then(this.stateConversationService.validateAndUpdateChat(marcimexCallbackResponse.getConversationId(), StatusUtil.ST_THINKAGENT, callbackId));
    }

    public ThinkAgentServiceImpl(TsaApiService tsaApiService, StateConversationService stateConversationService, ApiWhatsAppService whatsAppService, HistoryConversationItemService historyConversationItemService, HistoryConversationService historyConversationService, RedirectConversationService redirectConversationsService, ApiLhiaFLowService apiLhiaFLowService, ConversationDAO conversationDAO, HistoryConversationItemReactive historyConversationItemReactive, StartConversationEvents startConversationEvents, Environment env) {
        this.tsaApiService = tsaApiService;
        this.stateConversationService = stateConversationService;
        this.whatsAppService = whatsAppService;
        this.historyConversationItemService = historyConversationItemService;
        this.historyConversationService = historyConversationService;
        this.redirectConversationsService = redirectConversationsService;
        this.apiLhiaFLowService = apiLhiaFLowService;
        this.conversationDAO = conversationDAO;
        this.historyConversationItemReactive = historyConversationItemReactive;
        this.startConversationEvents = startConversationEvents;
        this.env = env;
    }
}

