/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.client.tsa.TsaApiService;
import com.whatsapp.tws2.client.tsa.models.AgentInboxResponse;
import com.whatsapp.tws2.client.tsa.models.TSAScheduleModel;
import com.whatsapp.tws2.service.ScheduleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private TsaApiService tsaApiService;

    public Mono<Void> saveSchedule(TSAScheduleModel tsaScheduleModel) {
        log.info("[TSA] Iniciando proceso de guardado v\u00eda tsaApiService. Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getAccount_id(), (Object)tsaScheduleModel.getInbox_id());
        return this.tsaApiService.saveScheduleByTSA(tsaScheduleModel).doOnSubscribe(subscription -> log.info("[TSA] Llamada a TSA iniciada. Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getAccount_id(), (Object)tsaScheduleModel.getInbox_id())).doOnSuccess(response -> log.info("[TSA] Llamada a TSA completada exitosamente. Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getAccount_id(), (Object)tsaScheduleModel.getInbox_id())).doOnError(error -> log.error("[TSA] Error al llamar a TSA. Account ID: {}, Inbox ID: {}. Error: {}", new Object[]{tsaScheduleModel.getAccount_id(), tsaScheduleModel.getInbox_id(), error.getMessage(), error})).then();
    }

    public Mono<Object> getSchedule() {
        log.info("[TSA] Iniciando proceso de guardado v\u00eda tsaApiService.");
        return this.tsaApiService.getScheduleByTSAData().doOnSubscribe(subscription -> log.info("[TSA] Llamada a TSA iniciada.")).doOnSuccess(response -> log.info("[TSA] Llamada a TSA completada exitosamente.")).doOnError(error -> log.error("[TSA] Error al llamar a TSA. Error: {}", (Object)error.getMessage(), error));
    }

    public Mono<List<AgentInboxResponse.AgentInbox>> getAllAgentByInbox() {
        log.info("[TSA] Iniciando proceso de obtencion de agentes v\u00eda tsaApiService.");
        return this.tsaApiService.getAllAgentByInboxByTSAData().doOnSubscribe(subscription -> log.info("[TSA] Llamada a TSA iniciada.")).doOnSuccess(response -> log.info("[TSA] Llamada a TSA completada exitosamente.")).doOnError(error -> log.error("[TSA] Error al llamar a TSA. Error: {}", (Object)error.getMessage(), error));
    }

    public ScheduleServiceImpl(TsaApiService tsaApiService) {
        this.tsaApiService = tsaApiService;
    }
}

