/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.ReportTimeResponse;
import com.whatsapp.tws2.Repository.ReportTimeResponseRepository;
import com.whatsapp.tws2.client.tsa.TsaApiService;
import com.whatsapp.tws2.client.tsa.models.AgentInboxResponse;
import com.whatsapp.tws2.client.tsa.models.DateTimeResponseDTO;
import com.whatsapp.tws2.client.tsa.models.Schedule;
import com.whatsapp.tws2.service.ReportTimeResponseService;
import com.whatsapp.tws2.service.impl.ReportTimeResponseServiceImpl;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ReportTimeResponseServiceImpl
implements ReportTimeResponseService {
    private static final Logger log = LoggerFactory.getLogger(ReportTimeResponseServiceImpl.class);
    private ReportTimeResponseRepository reportTimeResponseRepository;
    private TsaApiService tsaApiService;

    public Mono<Map<String, Object>> getListTimeResponse(DateTimeResponseDTO dateTimeResponseDTO) {
        log.info("[getListTimeResponse] Iniciando c\u00e1lculo con DTO: {}", (Object)dateTimeResponseDTO);
        return this.tsaApiService.getScheduleByTSA(dateTimeResponseDTO).doOnNext(schedules -> log.info("[getListTimeResponse] Schedules obtenidos: {}", (Object)schedules.size())).flatMap(schedules -> this.reportTimeResponseRepository.findByUserCreatedAtBetween(dateTimeResponseDTO.getInitDate(), dateTimeResponseDTO.getEndDate()).map(arg_0 -> this.ajustarFechasAZonaEcuadorIndividual(arg_0)).flatMap(item -> this.processSingleReport(item, schedules)).collect(Collectors.groupingBy(ResponseResult::type, Collectors.groupingBy(ResponseResult::date, Collectors.mapping(ResponseResult::seconds, Collectors.toList())))).map(groupedResults -> {
            log.info("[getListTimeResponse] Agrupaci\u00f3n reactiva completa.");
            Map mismoDiaMap = groupedResults.getOrDefault("mismoDia", Collections.emptyMap());
            Map diferenteDiaMap = groupedResults.getOrDefault("diferenteDia", Collections.emptyMap());
            Map sinRespuestaMap = groupedResults.getOrDefault("sinRespuesta", Collections.emptyMap());
            Function<Long, String> formatHHMMSS = seconds -> {
                long hrs = seconds / 3600L;
                long mins = seconds % 3600L / 60L;
                long secs = seconds % 60L;
                return String.format("%02d:%02d:%02d", hrs, mins, secs);
            };
            Function<Map, List> transformMap = map -> map.entrySet().stream().map(e -> {
                double rawAvg = ((List)e.getValue()).stream().mapToLong(Long::longValue).filter(s -> s >= 0L).average().orElse(0.0);
                long avg = (long)rawAvg;
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("fecha", ((LocalDate)e.getKey()).toString());
                res.put("tiempoPromedioSegundos", avg);
                res.put("tiempoPromedioHHMMSS", avg > 0L ? formatHHMMSS.apply(avg) : "-");
                res.put("cantidad", ((List)e.getValue()).size());
                return res;
            }).collect(Collectors.toList());
            HashMap<String, List> resultado = new HashMap<String, List>();
            resultado.put("mismoDia", transformMap.apply(mismoDiaMap));
            resultado.put("diferenteDia", transformMap.apply(diferenteDiaMap));
            resultado.put("sinRespuesta", transformMap.apply(sinRespuestaMap));
            log.info("[getListTimeResponse] Resultado final generado correctamente.");
            return resultado;
        }).defaultIfEmpty(Collections.emptyMap()));
    }

    private Mono<ResponseResult> processSingleReport(ReportTimeResponse item, List<Schedule> schedules) {
        LocalDateTime userCreatedAt = item.getUserCreatedAt();
        LocalDateTime agentCreatedAt = item.getSecondThinkAgentCreatedAt();
        if (agentCreatedAt == null || userCreatedAt == null) {
            LocalDate fecha = userCreatedAt != null ? userCreatedAt.toLocalDate() : LocalDate.now();
            return Mono.just((Object)new ResponseResult(fecha, -1L, "sinRespuesta"));
        }
        LocalDate userDate = userCreatedAt.toLocalDate();
        LocalDate agentDate = agentCreatedAt.toLocalDate();
        if (agentDate.equals(userDate)) {
            Duration total = Duration.between(userCreatedAt, agentCreatedAt);
            return Mono.just((Object)new ResponseResult(userDate, total.getSeconds(), "mismoDia"));
        }
        long workedSeconds = this.calculateWorkedSeconds(userCreatedAt, agentCreatedAt, schedules);
        return Mono.just((Object)new ResponseResult(userDate, workedSeconds, "diferenteDia"));
    }

    private ReportTimeResponse ajustarFechasAZonaEcuadorIndividual(ReportTimeResponse item) {
        ZoneId zonaEcuador = ZoneId.of("America/Guayaquil");
        ZoneOffset offsetEcuador = ZonedDateTime.now(zonaEcuador).getOffset();
        if (item.getUserCreatedAt() != null) {
            item.setUserCreatedAt(item.getUserCreatedAt().atOffset(ZoneOffset.UTC).withOffsetSameInstant(offsetEcuador).toLocalDateTime());
        }
        if (item.getSecondThinkAgentCreatedAt() != null) {
            item.setSecondThinkAgentCreatedAt(item.getSecondThinkAgentCreatedAt().atOffset(ZoneOffset.UTC).withOffsetSameInstant(offsetEcuador).toLocalDateTime());
        }
        return item;
    }

    private long calculateWorkedSeconds(LocalDateTime start, LocalDateTime end, List<Schedule> schedules) {
        AtomicLong workedSeconds = new AtomicLong(0L);
        LocalDateTime current = start;
        while (!current.isAfter(end)) {
            int dayOfWeek = current.getDayOfWeek().getValue() % 7;
            LocalDate currentDate = current.toLocalDate();
            LocalDateTime currentCopy = current;
            schedules.stream().filter(s -> s.getDayOfWeek() == (long)dayOfWeek).findFirst().ifPresent(schedule -> {
                if (!schedule.getClosedAllDay().booleanValue()) {
                    LocalDateTime effectiveEnd;
                    LocalDateTime open = currentDate.atTime(schedule.getOpenHour().intValue(), schedule.getOpenMinutes().intValue());
                    LocalDateTime close = currentDate.atTime(schedule.getCloseHour().intValue(), schedule.getCloseMinutes().intValue());
                    LocalDateTime effectiveStart = currentCopy.isBefore(open) ? open : currentCopy;
                    LocalDateTime localDateTime = effectiveEnd = end.isBefore(close) ? end : close;
                    if (!effectiveStart.isAfter(effectiveEnd)) {
                        Duration d = Duration.between(effectiveStart, effectiveEnd);
                        workedSeconds.addAndGet(d.getSeconds());
                    }
                }
            });
            current = current.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        }
        return workedSeconds.get();
    }

    public Mono<Map<String, Object>> getListTimeResponseByAgentUsername(DateTimeResponseDTO dateTimeResponseDTO) {
        log.info("[getListTimeResponseByAgentUsername] Iniciando c\u00e1lculo con DTO: {}", (Object)dateTimeResponseDTO);
        return this.tsaApiService.getScheduleByTSA(dateTimeResponseDTO).flatMap(schedules -> this.reportTimeResponseRepository.findByAgentUsernameAndUserCreatedAtBetween(dateTimeResponseDTO.getAgentUsername(), dateTimeResponseDTO.getInitDate(), dateTimeResponseDTO.getEndDate()).map(arg_0 -> this.ajustarFechasAZonaEcuadorIndividual(arg_0)).flatMap(item -> this.processSingleReport(item, schedules)).collect(Collectors.groupingBy(ResponseResult::type, Collectors.groupingBy(ResponseResult::date, Collectors.mapping(ResponseResult::seconds, Collectors.toList())))).map(groupedResults -> {
            Map mismoDiaMap = groupedResults.getOrDefault("mismoDia", Collections.emptyMap());
            Map diferenteDiaMap = groupedResults.getOrDefault("diferenteDia", Collections.emptyMap());
            Map sinRespuestaMap = groupedResults.getOrDefault("sinRespuesta", Collections.emptyMap());
            Function<Long, String> formatHHMMSS = seconds -> {
                long hrs = seconds / 3600L;
                long mins = seconds % 3600L / 60L;
                long secs = seconds % 60L;
                return String.format("%02d:%02d:%02d", hrs, mins, secs);
            };
            Function<Map, List> transformMap = map -> map.entrySet().stream().map(e -> {
                double rawAvg = ((List)e.getValue()).stream().mapToLong(Long::longValue).filter(s -> s >= 0L).average().orElse(0.0);
                long avg = (long)rawAvg;
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("fecha", ((LocalDate)e.getKey()).toString());
                res.put("tiempoPromedioSegundos", avg);
                res.put("tiempoPromedioHHMMSS", avg > 0L ? formatHHMMSS.apply(avg) : "-");
                res.put("cantidad", ((List)e.getValue()).size());
                return res;
            }).collect(Collectors.toList());
            HashMap<String, List> resultado = new HashMap<String, List>();
            resultado.put("mismoDia", transformMap.apply(mismoDiaMap));
            resultado.put("diferenteDia", transformMap.apply(diferenteDiaMap));
            resultado.put("sinRespuesta", transformMap.apply(sinRespuestaMap));
            return resultado;
        }));
    }

    private String formatHHMMSS(long seconds) {
        if (seconds < 0L) {
            return "-";
        }
        long hrs = seconds / 3600L;
        long mins = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d:%02d", hrs, mins, secs);
    }

    public Mono<Map<String, List<Map<String, Object>>>> getListTimeResponseByAllAgents(DateTimeResponseDTO dateTimeResponseDTO) {
        log.info("[getListTimeResponseByAllAgents] Iniciando c\u00e1lculo de promedios por agente.");
        return this.tsaApiService.getScheduleByTSA(dateTimeResponseDTO).flatMap(schedules -> this.tsaApiService.getAllAgentByInboxByTSAData().doOnNext(agents -> log.info("[getListTimeResponseByAllAgents] Agentes encontrados: {}", (Object)agents.size())).flatMapMany(Flux::fromIterable).flatMap(agent -> this.calculateAgentAverages(agent, schedules, dateTimeResponseDTO)).collectList().map(results -> {
            HashMap<String, List> finalMap = new HashMap<String, List>();
            finalMap.put("promedios", (List)results);
            log.info("[getListTimeResponseByAllAgents] C\u00e1lculo de promedios finalizado.");
            return finalMap;
        }).defaultIfEmpty(Map.of("promedios", Collections.emptyList())));
    }

    private Mono<Map<String, Object>> calculateAgentAverages(AgentInboxResponse.AgentInbox agent, List<Schedule> schedules, DateTimeResponseDTO dateTimeResponseDTO) {
        String username = agent.getEmail();
        return this.reportTimeResponseRepository.findByAgentUsernameAndUserCreatedAtBetween(username, dateTimeResponseDTO.getInitDate(), dateTimeResponseDTO.getEndDate()).map(arg_0 -> this.ajustarFechasAZonaEcuadorIndividual(arg_0)).flatMap(item -> this.processSingleReport(item, schedules)).collect(Collectors.groupingBy(ResponseResult::type, Collectors.mapping(ResponseResult::seconds, Collectors.toList()))).map(groupedResults -> {
            Function<List, Long> calculateAverageSeconds = secondsList -> {
                if (secondsList == null || secondsList.isEmpty()) {
                    return 0L;
                }
                double rawAvg = secondsList.stream().mapToLong(Long::longValue).filter(s -> s >= 0L).average().orElse(0.0);
                return (long)rawAvg;
            };
            List listMismoDia = groupedResults.getOrDefault("mismoDia", Collections.emptyList());
            List listDiferenteDia = groupedResults.getOrDefault("diferenteDia", Collections.emptyList());
            List listSinRespuesta = groupedResults.getOrDefault("sinRespuesta", Collections.emptyList());
            long avgSecondsMismoDia = calculateAverageSeconds.apply(listMismoDia);
            long avgSecondsDiferenteDia = calculateAverageSeconds.apply(listDiferenteDia);
            long avgSecondsSinRespuesta = 0L;
            long countMismoDia = listMismoDia.size();
            long countDiferenteDia = listDiferenteDia.size();
            long countSinRespuesta = listSinRespuesta.size();
            HashMap<String, Object> agentResult = new HashMap<String, Object>();
            agentResult.put("agent", agent.getName());
            agentResult.put("email", agent.getEmail());
            agentResult.put("mismoDia", this.formatHHMMSS(avgSecondsMismoDia));
            agentResult.put("totalMismoDia", countMismoDia);
            agentResult.put("diferenteDia", this.formatHHMMSS(avgSecondsDiferenteDia));
            agentResult.put("totalDiferenteDia", countDiferenteDia);
            agentResult.put("sinRespuesta", this.formatHHMMSS(avgSecondsSinRespuesta));
            agentResult.put("totalSinRespuesta", countSinRespuesta);
            return agentResult;
        }).defaultIfEmpty(Map.of("agent", agent.getName(), "email", agent.getEmail(), "mismoDia", this.formatHHMMSS(0L), "totalMismoDia", 0L, "diferenteDia", this.formatHHMMSS(0L), "totalDiferenteDia", 0L, "sinRespuesta", this.formatHHMMSS(0L), "totalSinRespuesta", 0L));
    }

    public ReportTimeResponseServiceImpl(ReportTimeResponseRepository reportTimeResponseRepository, TsaApiService tsaApiService) {
        this.reportTimeResponseRepository = reportTimeResponseRepository;
        this.tsaApiService = tsaApiService;
    }
}

