/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.HistoryConversationItemReactive;
import com.whatsapp.tws2.client.hiper.service.HiperApiService;
import com.whatsapp.tws2.client.lhiaflow.MarcimexCallbackResponse;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.FileMessageRequestFromHiper;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.service.HiperService;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.RedirectConversationService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.StatusUtil;
import com.whatsapp.tws2.web.service.WebChannelService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class HiperServiceImpl
implements HiperService {
    private static final Logger log = LoggerFactory.getLogger(HiperServiceImpl.class);
    private final ThinkAgentService thinkAgentService;
    private final StateConversationService stateConversationService;
    private final Environment env;
    private final ApiWhatsAppService whatsAppService;
    private final ObjectMapper mapper;
    private final HistoryConversationItemService historyConversationService;
    private final WebChannelService webChannelService;
    private final RedirectConversationService redirectConversationsService;
    private final HistoryConversationItemReactive historyConversationItemReactive;
    private final HiperApiService hiperApiService;

    public Mono<Void> receiveTemplateMessageFromHiper(Object request) {
        log.info("Sending message from lhiaflow {}", request);
        String defaultCallback = this.env.getProperty("lhiaflow.callback.atencion");
        MarcimexCallbackResponse obj = (MarcimexCallbackResponse)this.mapper.convertValue(request, MarcimexCallbackResponse.class);
        String channel = "whatsapp";
        HistoryConversationItem conversationDetailHistoryItem = HistoryConversationItem.saveConversationFromHyper((String)obj.getConversationId(), (String)(obj.getType().equals(MessageTypeUtils.TYPE_TEXT) ? obj.getPayload().getText() : obj.getPayload().getUrl()), (String)obj.getType());
        if (obj.getChannel() != null && obj.getChannel().equalsIgnoreCase("WEB")) {
            return this.historyConversationService.save(conversationDetailHistoryItem).then(this.webChannelService.sendMessageToBotpressWeb(obj)).then();
        }
        if (obj.getType().equals("text")) {
            boolean isRedirectEvent = this.redirectConversationsService.isEventRedirect(obj.getPayload().getText());
            if (isRedirectEvent) {
                return this.migrateConversationToTSA(obj);
            }
            TextMessageRequest model = new TextMessageRequest();
            model.setChannel("whatsapp");
            model.setMessage(obj.getPayload().getText());
            model.setPhoneNumber(obj.getConversationId());
            if (model.getMessage().toUpperCase().contains("EL CHAT FUE CERRADO")) {
                return this.redirectConversationToTsa(obj, conversationDetailHistoryItem, model, defaultCallback);
            }
            return this.sendTextMessage(model).then(this.historyConversationService.save(conversationDetailHistoryItem)).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).doOnError(error -> log.error("ERROR AL ENVIAR MENSAJES: ", error)).then();
        }
        if (obj.getType().equals("image")) {
            FileMessageRequestFromHiper model = new FileMessageRequestFromHiper();
            model.setCaption("imagen");
            model.setFileUrl(obj.getPayload().getUrl());
            model.setPhoneNumber(obj.getConversationId());
            return this.sendImageMessageReactive(model).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).then(this.historyConversationService.save(conversationDetailHistoryItem)).then();
        }
        if (obj.getType().equals("video")) {
            FileMessageRequestFromHiper model = new FileMessageRequestFromHiper();
            model.setCaption("video");
            model.setFileUrl(obj.getPayload().getUrl());
            model.setPhoneNumber(obj.getConversationId());
            return this.sendVideoMessageReactive(model).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).then(this.historyConversationService.save(conversationDetailHistoryItem)).doOnError(error -> log.error("ERROR AL ENVIAR VIDEOS: ", error)).then();
        }
        if (obj.getType().equals("file")) {
            FileMessageRequestFromHiper model = new FileMessageRequestFromHiper();
            model.setCaption("document");
            model.setFileUrl(obj.getPayload().getUrl());
            model.setPhoneNumber(obj.getConversationId());
            return this.sendDocumentMessageReactive(model).then(this.stateConversationService.validateStateAsesor(obj.getConversationId())).then(this.historyConversationService.save(conversationDetailHistoryItem)).doOnError(error -> log.error("ERROR AL ENVIAR VIDEOS: ", error)).then();
        }
        HashMap<String, String> successResponse = new HashMap<String, String>();
        successResponse.put("status", "success");
        return Mono.empty();
    }

    private Mono<Void> migrateConversationToTSA(MarcimexCallbackResponse obj) {
        log.info("REDIRECCIONANDO A TWS");
        return this.historyConversationItemReactive.getConversationHistoryOnMarkDownEstructure(obj.getPayload().getText(), obj.getConversationId()).flatMap(historyConversation -> {
            String event = obj.getPayload().getText();
            obj.getPayload().setText(historyConversation);
            return this.thinkAgentService.redirectConversationToTSA(event, obj).then(this.hiperApiService.closeConversationOnHiperPbx(obj.getRoomId())).then();
        });
    }

    private Mono<Void> redirectConversationToTsa(MarcimexCallbackResponse obj, HistoryConversationItem userHistoryConversation, TextMessageRequest model, String defaultCallback) {
        return this.stateConversationService.validateIfConversationWasRedirectedAndEventIdCloseFromHiper(obj.getConversationId(), StatusUtil.ST_NORMAL, defaultCallback).flatMap(actualStateConversation -> {
            if (actualStateConversation.equals(StatusUtil.ST_THINKAGENT)) {
                return this.historyConversationService.save(userHistoryConversation);
            }
            return this.sendTextMessage(model).then(this.historyConversationService.save(userHistoryConversation));
        }).doOnError(error -> log.error("ERROR AL ENVIAR MENSAJES: ", error)).then();
    }

    public Mono<ResponseEntity<String>> sendTextMessage(TextMessageRequest req) {
        log.info("Req on controller {}", (Object)req.getPhoneNumber());
        return this.stateConversationService.validateAndUpdateChatFromApi(req).doOnNext(estado -> log.warn("Estado de la conversaci\u00f3n: {}", estado)).flatMap(estado -> this.whatsAppService.sendTextMessage(req)).map(response -> ResponseEntity.ok((Object)"Text message sent successfully!")).onErrorResume(e -> {
            log.error("Failed to send template message ", e);
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send text message"));
        });
    }

    public Mono<ResponseEntity<String>> sendDocumentMessageReactive(FileMessageRequestFromHiper imageMessageRequest) {
        return this.whatsAppService.sendDocumentMessage(imageMessageRequest).map(response -> ResponseEntity.ok((Object)"Document message sent successfully!")).onErrorResume(e -> {
            System.out.println("Failed to send image message: " + e.getMessage());
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send image message"));
        });
    }

    public Mono<ResponseEntity<String>> sendVideoMessageReactive(FileMessageRequestFromHiper imageMessageRequest) {
        return this.whatsAppService.sendVideoMessage(imageMessageRequest).map(response -> ResponseEntity.ok((Object)"Video message sent successfully!")).onErrorResume(e -> {
            System.out.println("Failed to send image message: " + e.getMessage());
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send image message"));
        });
    }

    public Mono<ResponseEntity<String>> sendImageMessageReactive(FileMessageRequestFromHiper imageMessageRequest) {
        return this.whatsAppService.sendImageMessage(imageMessageRequest).map(response -> ResponseEntity.ok((Object)"Image message sent successfully!")).onErrorResume(e -> {
            System.out.println("Failed to send image message: " + e.getMessage());
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to send image message"));
        });
    }

    public HiperServiceImpl(ThinkAgentService thinkAgentService, StateConversationService stateConversationService, Environment env, ApiWhatsAppService whatsAppService, ObjectMapper mapper, HistoryConversationItemService historyConversationService, WebChannelService webChannelService, RedirectConversationService redirectConversationsService, HistoryConversationItemReactive historyConversationItemReactive, HiperApiService hiperApiService) {
        this.thinkAgentService = thinkAgentService;
        this.stateConversationService = stateConversationService;
        this.env = env;
        this.whatsAppService = whatsAppService;
        this.mapper = mapper;
        this.historyConversationService = historyConversationService;
        this.webChannelService = webChannelService;
        this.redirectConversationsService = redirectConversationsService;
        this.historyConversationItemReactive = historyConversationItemReactive;
        this.hiperApiService = hiperApiService;
    }
}

