/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.client.lhiaflow.LhiaFlowRequest;
import com.whatsapp.tws2.client.lhiaflow.service.ApiLhiaFLowService;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.service.AsesorHiperService;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.StatusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class AsesorHiperServiceImpl
implements AsesorHiperService {
    private static final Logger log = LoggerFactory.getLogger(AsesorHiperServiceImpl.class);
    private final Environment env;
    private final StateConversationService stateConversationService;
    private final ApiLhiaFLowService apiLhiaFLowService;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ApiWhatsAppService whatsAppService;
    private final HistoryConversationItemService historyConversationService;

    public Mono<ResponseEntity<?>> flujoAsesor(ExtractData usrBody, String defaultCallback, String estado) {
        log.info("WEBHOOK DATA {}", (Object)usrBody);
        return this.stateConversationService.getCallbackIdFromConversationId(usrBody.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
            LhiaFlowRequest messageModel = new LhiaFlowRequest();
            messageModel.setChannel(usrBody.getCanal());
            messageModel.setConversationChatId(usrBody.getIdConversation());
            messageModel.setNick(usrBody.getNick());
            messageModel.setMessage(usrBody.getMessage());
            messageModel.setFile(usrBody.getFile());
            messageModel.setCallbackId(callbackId == null ? defaultCallback : callbackId);
            messageModel.setType(usrBody.getType());
            messageModel.setLongitude(usrBody.getLongitude());
            messageModel.setLatitude(usrBody.getLatitude());
            log.info("messageModel {}", (Object)messageModel);
            if (StatusUtil.ST_CAMPANA.equals(estado)) {
                return this.campaignMessageDAO.findLastMessageTemplateByConversationId(usrBody.getIdConversation()).flatMap(message -> {
                    if (!message.isBlank()) {
                        String messageOriginal = messageModel.getMessage() == null ? "" : messageModel.getMessage();
                        String newMessageModified = "Msg usuario: " + messageOriginal + "\n;Campa\u00f1a: " + message;
                        messageModel.setMessage(newMessageModified);
                        log.warn("EL ESTADO ACTUAL ES: {}", (Object)messageModel.getMessage());
                        if (!messageModel.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                            LhiaFlowRequest textMessageModel = new LhiaFlowRequest();
                            textMessageModel.setChannel(messageModel.getChannel());
                            textMessageModel.setConversationChatId(messageModel.getConversationChatId());
                            textMessageModel.setNick(messageModel.getNick());
                            textMessageModel.setMessage("Campa\u00f1a: " + message);
                            textMessageModel.setCallbackId(messageModel.getCallbackId());
                            textMessageModel.setType(MessageTypeUtils.TYPE_TEXT);
                            return this.apiLhiaFLowService.sendMesssageToAsesor(textMessageModel).then(this.historyConversationService.saveHistoryConversations(textMessageModel, "USER")).then(this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).then(this.historyConversationService.saveHistoryConversations(messageModel, "USER")).then(this.stateConversationService.validateAndUpdateChat(messageModel.getConversationChatId(), StatusUtil.ST_ASESOR, callbackId)).map(res -> ResponseEntity.ok().build()));
                        }
                        return this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).then(this.historyConversationService.saveHistoryConversations(messageModel, "USER")).then(this.stateConversationService.validateAndUpdateChat(messageModel.getConversationChatId(), StatusUtil.ST_ASESOR, callbackId)).map(res -> ResponseEntity.ok().build());
                    }
                    return this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).map(res -> ResponseEntity.ok().build());
                });
            }
            return this.apiLhiaFLowService.sendMesssageToAsesor(messageModel).defaultIfEmpty((Object)"").flatMap(data -> this.saveHistoryConversations(messageModel, data)).flatMap(result -> {
                String mensajeToAnalis;
                String string = mensajeToAnalis = messageModel.getMessage() != null ? messageModel.getMessage().toUpperCase().replace(" ", "") : "";
                if (mensajeToAnalis.equals(estado)) {
                    TextMessageRequest textMessagaReq = new TextMessageRequest(messageModel.getConversationChatId(), StatusUtil.MSG_SOLICITUD_ASESOR);
                    return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(res -> {
                        log.info("Mensaje enviado a WhatsApp: {}", res);
                        return Mono.just((Object)ResponseEntity.ok().build());
                    });
                }
                return Mono.just((Object)ResponseEntity.ok().build());
            }).doOnError(error -> log.error("Error occurred during message sending", error)).onErrorResume(error -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build()));
        });
    }

    private Mono<String> saveHistoryConversations(LhiaFlowRequest messageModel, String data) {
        HistoryConversationItem userConversation = HistoryConversationItem.saveConversationFromMeta((String)messageModel.getConversationChatId(), (String)messageModel.getMessage(), (String)messageModel.getType(), (String)messageModel.getNick());
        return this.historyConversationService.save(userConversation).thenReturn((Object)data);
    }

    public Mono<ResponseEntity<String>> sendMessagetoAsesorFromApi(LhiaFlowRequest body) {
        body.setCallbackId(this.env.getProperty("tsa.canal.callback.ventas"));
        return this.apiLhiaFLowService.sendMesssageToAsesor(body).defaultIfEmpty((Object)"").flatMap(data -> this.saveHistoryConversations(body, data)).flatMap(result -> {
            TextMessageRequest textMessagaReq = new TextMessageRequest(body.getConversationChatId(), StatusUtil.MSG_SOLICITUD_ASESOR);
            return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(res -> {
                log.info("Mensaje enviado a WhatsApp: {}", res);
                return Mono.just((Object)ResponseEntity.ok().body((Object)""));
            });
        }).doOnError(error -> log.error("Error occurred during message sending", error)).onErrorResume(error -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build()));
    }

    public AsesorHiperServiceImpl(Environment env, StateConversationService stateConversationService, ApiLhiaFLowService apiLhiaFLowService, CampaignMessageDAO campaignMessageDAO, ApiWhatsAppService whatsAppService, HistoryConversationItemService historyConversationService) {
        this.env = env;
        this.stateConversationService = stateConversationService;
        this.apiLhiaFLowService = apiLhiaFLowService;
        this.campaignMessageDAO = campaignMessageDAO;
        this.whatsAppService = whatsAppService;
        this.historyConversationService = historyConversationService;
    }
}

