/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.data;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class ConversationSummary {
    private String category;
    private int totalConversations;
    private double totalCost;

    public ConversationSummary(String category, int totalConversations, double totalCost) {
        this.category = category;
        this.totalConversations = totalConversations;
        this.totalCost = this.roundToTwoDecimals(totalCost);
    }

    private double roundToTwoDecimals(double value) {
        return BigDecimal.valueOf(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getTotalConversations() {
        return this.totalConversations;
    }

    public void setTotalConversations(int totalConversations) {
        this.totalConversations = totalConversations;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(double totalCost) {
        this.totalCost = this.roundToTwoDecimals(totalCost);
    }
}

