/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.data.tsa.RequestMessageModel;
import com.whatsapp.tws2.service.ThinkAgentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/tsa"})
public class ThinkAgentController {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentController.class);
    private final ThinkAgentService agentService;
    private final Environment env;

    @PostMapping(value={"/message"})
    public Mono<ResponseEntity<String>> sendMessageToTAS(@RequestBody RequestMessageModel requestMessageModel) {
        log.info("MENSAJE ENTRANTE {}", (Object)requestMessageModel);
        return this.agentService.sendMessageToWhatsappFromTSA(requestMessageModel);
    }

    public ThinkAgentService getAgentService() {
        return this.agentService;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThinkAgentController)) {
            return false;
        }
        ThinkAgentController other = (ThinkAgentController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ThinkAgentService this$agentService = this.getAgentService();
        ThinkAgentService other$agentService = other.getAgentService();
        if (this$agentService == null ? other$agentService != null : !this$agentService.equals(other$agentService)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThinkAgentController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThinkAgentService $agentService = this.getAgentService();
        result = result * 59 + ($agentService == null ? 43 : $agentService.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "ThinkAgentController(agentService=" + String.valueOf(this.getAgentService()) + ", env=" + String.valueOf(this.getEnv()) + ")";
    }

    public ThinkAgentController(ThinkAgentService agentService, Environment env) {
        this.agentService = agentService;
        this.env = env;
    }
}

