/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.client.tsa.models.AgentInboxResponse;
import com.whatsapp.tws2.client.tsa.models.TSAScheduleModel;
import com.whatsapp.tws2.service.ScheduleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/schedules"})
public class SchedulesController {
    private static final Logger log = LoggerFactory.getLogger(SchedulesController.class);
    private ScheduleService scheduleService;

    @PostMapping(value={""})
    public Mono<ResponseEntity<String>> saveSchedule(@RequestBody TSAScheduleModel tsaScheduleModel) {
        log.info("[TSA] Inicio de actualizaci\u00f3n de horario. Datos recibidos: {}", (Object)tsaScheduleModel);
        return this.scheduleService.saveSchedule(tsaScheduleModel).doOnSubscribe(subscription -> log.debug("[TSA] Proceso de guardado iniciado para Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getInbox_id(), (Object)tsaScheduleModel.getAccount_id())).doOnSuccess(unused -> log.info("[TSA] Guardado exitoso del horario para Account ID: {}, Inbox ID: {}", (Object)tsaScheduleModel.getInbox_id(), (Object)tsaScheduleModel.getAccount_id())).doOnError(error -> log.error("[TSA] Error al guardar el horario para Account ID: {}, Inbox ID: {}. Error: {}", new Object[]{tsaScheduleModel.getInbox_id(), tsaScheduleModel.getAccount_id(), error.getMessage(), error})).then(Mono.just((Object)ResponseEntity.ok((Object)"Update Schedules")));
    }

    @GetMapping(value={""})
    public Mono<ResponseEntity<Object>> getSchedule() {
        log.info("[TSA] Inicio de actualizaci\u00f3n de horario. Datos: {}");
        return this.scheduleService.getSchedule().doOnSubscribe(subscription -> log.debug("[TSA] Proceso de guardado iniciado:")).doOnSuccess(unused -> log.info("[TSA] Guardado exitoso del horario")).doOnError(error -> log.error("[TSA] Error al guardar el horario. Error: {}", (Object)error.getMessage(), error)).map(result -> ResponseEntity.ok().body(result));
    }

    @GetMapping(value={"/all_agent_inbox"})
    public Mono<ResponseEntity<List<AgentInboxResponse.AgentInbox>>> getAllAgentByInbox() {
        log.info("[TSA] Inicio de obtencion de agentes. Datos: {}");
        return this.scheduleService.getAllAgentByInbox().doOnSubscribe(subscription -> log.debug("[TSA] Proceso de obtencion de agentes iniciado:")).doOnSuccess(unused -> log.info("[TSA] obtencion de agentes exitoso del horario")).doOnError(error -> log.error("[TSA] Error al obtencion de agentes. Error: {}", (Object)error.getMessage(), error)).map(result -> ResponseEntity.ok().body(result));
    }

    public SchedulesController(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }
}

