/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.client.tsa.models.DateTimeResponseDTO;
import com.whatsapp.tws2.service.ReportTimeResponseService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/report-time-response"})
public class ReportTimeSendController {
    private static final Logger log = LoggerFactory.getLogger(ReportTimeSendController.class);
    private ReportTimeResponseService viewReportTimeSendService;

    @PostMapping(consumes={"application/json"})
    public Mono<Map<String, Object>> getTimeResponse(@RequestBody DateTimeResponseDTO body) {
        return this.viewReportTimeSendService.getListTimeResponse(body);
    }

    @PostMapping(value={"/agent"}, consumes={"application/json"})
    public Mono<Map<String, Object>> getTimeResponseAgent(@RequestBody DateTimeResponseDTO body) {
        return this.viewReportTimeSendService.getListTimeResponseByAgentUsername(body);
    }

    @PostMapping(value={"/allAgentReportPromedio"}, consumes={"application/json"})
    public Mono<Map<String, List<Map<String, Object>>>> getAgentReportForEveryAgent(@RequestBody DateTimeResponseDTO body) {
        log.info("Request received to generate total agent response time report.");
        return this.viewReportTimeSendService.getListTimeResponseByAllAgents(body);
    }

    public ReportTimeResponseService getViewReportTimeSendService() {
        return this.viewReportTimeSendService;
    }

    public void setViewReportTimeSendService(ReportTimeResponseService viewReportTimeSendService) {
        this.viewReportTimeSendService = viewReportTimeSendService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportTimeSendController)) {
            return false;
        }
        ReportTimeSendController other = (ReportTimeSendController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ReportTimeResponseService this$viewReportTimeSendService = this.getViewReportTimeSendService();
        ReportTimeResponseService other$viewReportTimeSendService = other.getViewReportTimeSendService();
        return !(this$viewReportTimeSendService == null ? other$viewReportTimeSendService != null : !this$viewReportTimeSendService.equals(other$viewReportTimeSendService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportTimeSendController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReportTimeResponseService $viewReportTimeSendService = this.getViewReportTimeSendService();
        result = result * 59 + ($viewReportTimeSendService == null ? 43 : $viewReportTimeSendService.hashCode());
        return result;
    }

    public String toString() {
        return "ReportTimeSendController(viewReportTimeSendService=" + String.valueOf(this.getViewReportTimeSendService()) + ")";
    }

    public ReportTimeSendController(ReportTimeResponseService viewReportTimeSendService) {
        this.viewReportTimeSendService = viewReportTimeSendService;
    }
}

