/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.client.lhia.service.ApiLhiaService;
import com.whatsapp.tws2.data.RequestQuestionLhia;
import com.whatsapp.tws2.data.ResponseLhia;
import com.whatsapp.tws2.data.TokenKeyCloakModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/lhia"})
public class LhiaController {
    private static final Logger log = LoggerFactory.getLogger(LhiaController.class);
    private final ApiLhiaService apiLhiaService;

    @PostMapping(value={"/ia"})
    public Mono<ResponseLhia> sendMesssageToLhiaIa(@RequestBody RequestQuestionLhia data) {
        log.info("Sending message to lhia {}", (Object)data);
        return this.apiLhiaService.getToken().flatMap(tokenModel -> this.apiLhiaService.sendMesssageToLhia(data, tokenModel.getAccessToken()).flatMap(responseLhia -> this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia)));
    }

    @PostMapping(value={"/token"})
    public Mono<TokenKeyCloakModel> getToken() {
        log.info("Getting token from lhia");
        return this.apiLhiaService.getToken();
    }

    public ApiLhiaService getApiLhiaService() {
        return this.apiLhiaService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LhiaController)) {
            return false;
        }
        LhiaController other = (LhiaController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ApiLhiaService this$apiLhiaService = this.getApiLhiaService();
        ApiLhiaService other$apiLhiaService = other.getApiLhiaService();
        return !(this$apiLhiaService == null ? other$apiLhiaService != null : !this$apiLhiaService.equals(other$apiLhiaService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LhiaController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiLhiaService $apiLhiaService = this.getApiLhiaService();
        result = result * 59 + ($apiLhiaService == null ? 43 : $apiLhiaService.hashCode());
        return result;
    }

    public String toString() {
        return "LhiaController(apiLhiaService=" + String.valueOf(this.getApiLhiaService()) + ")";
    }

    public LhiaController(ApiLhiaService apiLhiaService) {
        this.apiLhiaService = apiLhiaService;
    }
}

