/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.client.whatsapp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ConversationAnalyticsResponse;
import com.whatsapp.tws2.data.ConversationSummary;
import com.whatsapp.tws2.data.ConversationSummaryResponse;
import com.whatsapp.tws2.data.EventMotoPower;
import com.whatsapp.tws2.data.FileMessageRequestFromHiper;
import com.whatsapp.tws2.data.FileModelWhatsapp;
import com.whatsapp.tws2.data.TemplateMessageRequest;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.templatesMeta.TemplateData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiWhatsApp
implements ApiWhatsAppService {
    private static final Logger log = LoggerFactory.getLogger(ApiWhatsApp.class);
    private final WebClient.Builder webClient;
    private final Environment env;
    private final ObjectMapper objectMapper;

    public Mono<String> sendMessageTemplateToWhatsAppAPI(Object payload) {
        String apiToken = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        log.warn(payload.toString());
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).header("Authorization", new String[]{"Bearer " + apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)payload)).retrieve().bodyToMono(String.class).doOnNext(response -> log.info("Message template sent successfully: {}", response)).doOnError(e -> log.error("Error sending message template", e));
    }

    public Mono<TemplateData> getTemplates() {
        String WHATSAPP_API_TEMPLATE = this.env.getProperty("whatsapp.api.templates");
        String apiToken = this.env.getProperty("whatsapp.token");
        return this.webClient.build().get().uri(WHATSAPP_API_TEMPLATE, new Object[0]).header("Authorization", new String[]{"Bearer " + apiToken}).retrieve().bodyToMono(TemplateData.class).doOnNext(response -> log.info("Call success to templates meta")).doOnError(e -> log.error("Error on get templates from meta", e));
    }

    public Mono<String> sendToWhatsAppAPI(TemplateMessageRequest request) {
        String apiToken = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).header("Authorization", new String[]{"Bearer " + apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)request)).retrieve().bodyToMono(String.class).doOnNext(response -> log.info("Message sent successfully: {}", response)).doOnError(e -> log.error("Error sending message", e));
    }

    public Mono<String> sendToWhatsAppAPI(EventMotoPower request) {
        String apiToken = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).header("Authorization", new String[]{"Bearer " + apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)request)).retrieve().bodyToMono(String.class).doOnNext(response -> log.info("Message sent successfully: {}", response)).doOnError(e -> log.error("Error sending message", e));
    }

    public Mono<FileModelWhatsapp> downloadMediaFile(String mediaId) {
        log.info("Downloading mediaFile from {}", (Object)mediaId);
        String apiToken = this.env.getProperty("whatsapp.token");
        String templateUrlMediaFile = this.env.getProperty("whatsapp.api.media");
        templateUrlMediaFile = templateUrlMediaFile.replace("{mediaId}", mediaId);
        return this.webClient.build().get().uri(templateUrlMediaFile, new Object[0]).header("Authorization", new String[]{"Bearer " + apiToken}).retrieve().bodyToMono(FileModelWhatsapp.class).doOnError(e -> log.error("Error downloading file", e)).onErrorResume(e -> Mono.empty());
    }

    public Mono<byte[]> downloadFileFromUrl(String fileUrl) {
        log.info("Downloading file from URL: {}", (Object)fileUrl);
        String apiToken = this.env.getProperty("whatsapp.token");
        return this.webClient.build().get().uri(fileUrl, new Object[0]).header("Authorization", new String[]{"Bearer " + apiToken}).retrieve().bodyToMono(byte[].class).doOnError(e -> log.error("Error downloading file from URL", e)).onErrorResume(e -> Mono.empty());
    }

    public Mono<ResponseEntity<String>> sendTextMessage(TextMessageRequest req) {
        log.info("Sending text message to {}", (Object)req.getPhoneNumber());
        return this.validateIfMessageIsEventFromHyper(req.getMessage()).flatMap(isEvent -> {
            if (isEvent.booleanValue()) {
                return Mono.just((Object)ResponseEntity.ok((Object)"status"));
            }
            String TOKEN = this.env.getProperty("whatsapp.token");
            String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(TOKEN);
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("messaging_product", "whatsapp");
            body.put("to", req.getPhoneNumber());
            body.put("type", "text");
            body.put("text", Collections.singletonMap("body", req.getMessage()));
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> {
                if (response.getStatusCode() == HttpStatus.OK) {
                    log.info("Text message sent successfully!");
                } else {
                    log.error("Failed to send text message: " + (String)response.getBody());
                }
            }).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody()))));
        });
    }

    public String getMessageMetaId(String jsonString) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(jsonString);
            JsonNode messagesNode = rootNode.path("messages");
            if (messagesNode.isArray() && messagesNode.size() > 0) {
                String messageId = messagesNode.get(0).path("id").asText();
                System.out.println("ID del mensaje: " + messageId);
                return messageId;
            }
            System.out.println("No se encontr\u00f3 el ID del mensaje.");
            return UUID.randomUUID().toString();
        }
        catch (Exception e) {
            return UUID.randomUUID().toString();
        }
    }

    private Mono<Boolean> validateIfMessageIsEventFromHyper(String message) {
        String msg = message.toUpperCase();
        return Mono.just((Object)(msg.contains("EL CHAT FUE ACEPTADO") || msg.contains("EL CHAT FUE ASIGNADO") || msg.contains("EL CHAT FUE TRANSFERIDO") ? 1 : 0));
    }

    public Mono<ResponseEntity<String>> sendTextMessageWithButton(Map<String, Object> body) {
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().onStatus(status -> status.is4xxClientError() || status.is5xxServerError(), clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorBody -> {
            log.error("WhatsApp API error {}: {}", (Object)clientResponse.statusCode(), errorBody);
            return Mono.error((Throwable)new RuntimeException("WhatsApp API error: " + errorBody));
        })).toEntity(String.class).doOnSuccess(response -> {
            if (response.getStatusCode() == HttpStatus.OK) {
                log.info("Text message sent successfully!");
            } else {
                log.error("Failed to send text message: " + (String)response.getBody());
            }
        });
    }

    public Mono<ResponseEntity<String>> sendImageMessage(FileMessageRequestFromHiper req) {
        log.info("Sending image {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "image");
        HashMap<String, String> image = new HashMap<String, String>();
        image.put("link", req.getFileUrl());
        if (req.getCaption() != null && !req.getCaption().isEmpty()) {
            image.put("caption", req.getCaption());
        }
        body.put("image", image);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Image message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending image message: ", error));
    }

    public Mono<ResponseEntity<String>> sendVideoMessage(FileMessageRequestFromHiper req) {
        log.info("Sending image {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "video");
        HashMap<String, String> video = new HashMap<String, String>();
        video.put("link", req.getFileUrl());
        if (req.getCaption() != null && !req.getCaption().isEmpty()) {
            video.put("caption", req.getCaption());
        }
        body.put("video", video);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Image message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending video message: ", error));
    }

    public Mono<ResponseEntity<String>> sendDocumentMessage(FileMessageRequestFromHiper req) {
        log.info("Sending image {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "document");
        HashMap<String, String> file = new HashMap<String, String>();
        file.put("link", req.getFileUrl());
        if (req.getCaption() != null && !req.getCaption().isEmpty()) {
            file.put("caption", req.getCaption());
        }
        body.put("document", file);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Image message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending video message: ", error));
    }

    public Mono<ResponseEntity<String>> sendAudioMessage(FileMessageRequestFromHiper req) {
        log.info("Sending audio {}", (Object)req);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("messaging_product", "whatsapp");
        body.put("to", req.getPhoneNumber());
        body.put("type", "audio");
        HashMap<String, String> file = new HashMap<String, String>();
        file.put("link", req.getFileUrl());
        body.put("audio", file);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().toEntity(String.class).doOnSuccess(response -> log.info("Audio message sent successfully!")).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)this.getMessageMetaId((String)response.getBody())))).doOnError(error -> log.error("Error sending audio message: ", error));
    }

    public Mono<Void> markMessageAsRead(String messageId) {
        log.info("Marking as read to messageId {}", (Object)messageId);
        String TOKEN = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + TOKEN);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("messaging_product", "whatsapp");
        requestBody.put("status", "read");
        requestBody.put("message_id", messageId);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).body(BodyInserters.fromValue(requestBody)).retrieve().onStatus(status -> status.is4xxClientError() || status.is5xxServerError(), clientResponse -> Mono.error((Throwable)new RuntimeException("Failed to mark message as read"))).bodyToMono(Void.class);
    }

    public Mono<ResponseEntity<String>> verifyWebhook(String verifyToken, String challenge) {
        log.info("Verificando webhook con token: {} y challenge: {}", (Object)verifyToken, (Object)challenge);
        String VERIFY_TOKEN = this.env.getProperty("whatsapp.verify.token");
        if (VERIFY_TOKEN.equals(verifyToken)) {
            return Mono.just((Object)new ResponseEntity((Object)challenge, (HttpStatusCode)HttpStatus.OK));
        }
        log.error("Error de verificaci\u00f3n: token no coincide");
        return Mono.just((Object)new ResponseEntity((Object)"Error de verificaci\u00f3n", (HttpStatusCode)HttpStatus.FORBIDDEN));
    }

    public Mono<ConversationAnalyticsResponse> getConversationAnalytics(Date fecha_inicio, Date fecha_fin) {
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.business.url");
        String TOKEN = this.env.getProperty("whatsapp.token");
        long fecha_inicio_tsp = fecha_inicio.getTime() / 1000L;
        long fecha_fin_tsp = fecha_fin.getTime() / 1000L;
        return this.webClient.build().get().uri(WHATSAPP_API_URL + "/?fields=conversation_analytics.start(" + fecha_inicio_tsp + ").end(" + fecha_fin_tsp + ").granularity(DAILY).dimensions(CONVERSATION_CATEGORY).conversation_types(REGULAR)", new Object[0]).header("Authorization", new String[]{"Bearer " + TOKEN}).retrieve().bodyToMono(ConversationAnalyticsResponse.class).doOnError(e -> log.error("Error downloading file", e)).onErrorResume(e -> Mono.empty());
    }

    public Mono<ConversationSummaryResponse> getConversationSummary(Date fecha_inicio, Date fecha_fin) {
        double MARKETING_COST = 0.1542;
        double UTILITY_COST = 0.0235;
        double SERVICE_COST = 0.0881;
        return this.getConversationAnalytics(fecha_inicio, fecha_fin).map(response -> {
            Map<String, Integer> conversationCounts = response.getConversationAnalytics().getData().stream().flatMap(data -> data.getDataPoints().stream()).collect(Collectors.groupingBy(ConversationAnalyticsResponse.DataPoint::getConversationCategory, Collectors.summingInt(ConversationAnalyticsResponse.DataPoint::getConversation)));
            List summaries = conversationCounts.entrySet().stream().map(entry -> {
                String category = (String)entry.getKey();
                int totalConversations = (Integer)entry.getValue();
                double costPerConversation = 0.0;
                switch (category.toUpperCase()) {
                    case "MARKETING": {
                        costPerConversation = MARKETING_COST;
                        break;
                    }
                    case "UTILITY": {
                        costPerConversation = UTILITY_COST;
                        break;
                    }
                    case "SERVICE": {
                        costPerConversation = SERVICE_COST;
                    }
                }
                double totalCost = (double)totalConversations * costPerConversation;
                return new ConversationSummary(category, totalConversations, totalCost);
            }).collect(Collectors.toList());
            double totalCost = summaries.stream().mapToDouble(ConversationSummary::getTotalCost).sum();
            totalCost = BigDecimal.valueOf(totalCost).setScale(2, RoundingMode.HALF_UP).doubleValue();
            return new ConversationSummaryResponse(summaries, totalCost);
        });
    }

    public ApiWhatsApp(WebClient.Builder webClient, Environment env, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.env = env;
        this.objectMapper = objectMapper;
    }
}

